/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigUmbrella {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    public static ForgeConfigSpec.IntValue configIronUmbrellaDurability;
    public static ForgeConfigSpec.IntValue configGoldUmbrellaDurability;
    public static ForgeConfigSpec.IntValue configDiamondUmbrellaDurability;
    public static ForgeConfigSpec.IntValue configNetheriteUmbrellaDurability;
    public static ForgeConfigSpec.DoubleValue configIronUmbrellaSpeed;
    public static ForgeConfigSpec.DoubleValue configGoldUmbrellaSpeed;
    public static ForgeConfigSpec.DoubleValue configDiamondUmbrellaSpeed;
    public static ForgeConfigSpec.DoubleValue configNetheriteUmbrellaSpeed;
    public static ForgeConfigSpec.BooleanValue configUmbrellaMainHand;
    public static ForgeConfigSpec.BooleanValue configUmbrellaOffHand;
    public static ForgeConfigSpec.BooleanValue configUmbrellaAnvil;
    public static ForgeConfigSpec.BooleanValue configUmbrellaRepair;
    public static ForgeConfigSpec.BooleanValue configCreativeUmbrellaConfigs;

    public static class General {
        public General(ForgeConfigSpec.Builder builder) {
            builder.push("Umbrellas Durability");
            configIronUmbrellaDurability = builder.comment("The durability in seconds of the Iron Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.ironUmbrellaDurability").defineInRange("ironUmbrellaDurability", 600, -1, 432000);
            configGoldUmbrellaDurability = builder.comment("The durability in seconds of the Gold Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.goldUmbrellaDurability").defineInRange("goldUmbrellaDurability", 2400, -1, 432000);
            configDiamondUmbrellaDurability = builder.comment("The durability in seconds of the Diamond Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.diamondUmbrellaDurability").defineInRange("diamondUmbrellaDurability", 9600, -1, 432000);
            configNetheriteUmbrellaDurability = builder.comment("The durability in seconds of the Netherite Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.netheriteUmbrellaDurability").defineInRange("netheriteUmbrellaDurability", 14400, -1, 432000);
            builder.pop();
            builder.push("Umbrellas Speed");
            configIronUmbrellaSpeed = builder.comment("The Speed Modifier of the Umbrella. Set to 0 to disable.").translation("vampiresneedumbrellas.config.ironUmbrellaSpeed").defineInRange("ironUmbrellaSpeed", -0.35, -1.0, 1.0);
            configGoldUmbrellaSpeed = builder.comment("The Speed Modifier of the Umbrella. Set to 0 to disable.").translation("vampiresneedumbrellas.config.goldUmbrellaSpeed").defineInRange("goldUmbrellaSpeed", -0.35, -1.0, 1.0);
            configDiamondUmbrellaSpeed = builder.comment("The Speed Modifier of the Umbrella. Set to 0 to disable.").translation("vampiresneedumbrellas.config.diamondUmbrellaSpeed").defineInRange("diamondUmbrellaSpeed", -0.35, -1.0, 1.0);
            configNetheriteUmbrellaSpeed = builder.comment("The Speed Modifier of the Umbrella. Set to 0 to disable.").translation("vampiresneedumbrellas.config.netheriteUmbrellaSpeed").defineInRange("netheriteUmbrellaSpeed", -0.35, -1.0, 1.0);
            builder.pop();
            builder.push("Umbrellas Mechanics");
            configUmbrellaMainHand = builder.comment("Set to false if you don't want the umbrella to work in the main-hand").translation("vampiresneedumbrellas.config.umbrellaMainHand").define("umbrellaMainHand", true);
            configUmbrellaOffHand = builder.comment("Set to false if you don't want the umbrella to work in the off-hand").translation("vampiresneedumbrellas.config.umbrellaOffHand").define("umbrellaOffHand", true);
            configUmbrellaAnvil = builder.comment("Set to false if you don't want the umbrella to be enchanted using anvils.").translation("vampiresneedumbrellas.config.umbrellaAnvil").define("umbrellaAnvil", true);
            configUmbrellaRepair = builder.comment("Set to false if you don't want umbrellas to be repaired using an anvil and the material it is made from.").translation("vampiresneedumbrellas.config.umbrellaRepair").define("umbrellaRepair", true);
            builder.pop();
            builder.push("Others");
            configCreativeUmbrellaConfigs = builder.comment("If true, the Creative Umbrella will respect the \"umbrellaMainHand\" and \"umbrellaOffHand\" configs.\nIf false, the Creative Umbrella will always works in main-hand and off-hand").translation("vampiresneedumbrellas.config.creativeUmbrellaConfigs").define("creativeUmbrellaConfigs", false);
            builder.pop();
        }
    }
}

