/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.handlers;

import com.focamacho.vampiresneedumbrellas.config.ConfigHolder;
import com.focamacho.vampiresneedumbrellas.handlers.CuriosHandler;
import com.focamacho.vampiresneedumbrellas.potions.SunscreenEffectInstance;
import com.focamacho.vampiresneedumbrellas.utils.Utils;
import de.teamlapen.vampirism.api.VReference;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ObjectHolder;
import top.theillusivec4.curios.api.SlotResult;

public class VampirismHandler {
    @ObjectHolder(registryName="mob_effect", value="vampirism:sunscreen")
    public static MobEffect vampirism_sunscreen;

    public static void applyEffect(ItemStack stack, Level world, Entity entityIn, boolean breakable) {
        if (VampirismHandler.canApplyEffect(entityIn)) {
            Optional<SlotResult> opt;
            Player player = (Player)entityIn;
            if (ConfigHolder.umbrellaMainHand && player.m_21205_().equals(stack) || ConfigHolder.umbrellaOffHand && player.m_21206_().equals(stack)) {
                player.m_7292_((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
                if (breakable && VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(v -> v.isGettingSundamage((LevelAccessor)world)).orElse(false).booleanValue()) {
                    stack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                }
                return;
            }
            if (Utils.isCuriosLoaded && (opt = CuriosHandler.getUmbrellaEquiped(stack, player)).isPresent()) {
                SlotResult umbrella = opt.get();
                player.m_7292_((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
                if (breakable && VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(v -> v.isGettingSundamage((LevelAccessor)world)).orElse(false).booleanValue()) {
                    String id = umbrella.slotContext().identifier();
                    int index = umbrella.slotContext().index();
                    stack.m_41622_(1, (LivingEntity)player, consumer -> CuriosHandler.onBrokenCurio(id, index, consumer));
                }
            }
        }
    }

    public static void applyCreativeEffect(ItemStack stack, Entity entityIn) {
        if (VampirismHandler.canApplyEffect(entityIn)) {
            Player player = (Player)entityIn;
            if (ConfigHolder.creativeUmbrellaConfigs && (ConfigHolder.umbrellaMainHand && player.m_21205_().equals(stack) || ConfigHolder.umbrellaOffHand && player.m_21206_().equals(stack))) {
                player.m_7292_((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
            } else if (player.m_21205_().equals(stack) || player.m_21206_().equals(stack) || Utils.isCuriosLoaded && CuriosHandler.getUmbrellaEquiped(stack, player).isPresent()) {
                player.m_7292_((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
            } else if (Utils.isCuriosLoaded && CuriosHandler.getUmbrellaEquiped(stack, player).isPresent()) {
                player.m_7292_((MobEffectInstance)new SunscreenEffectInstance(vampirism_sunscreen));
            }
        }
    }

    private static boolean canApplyEffect(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        MobEffectInstance effectInstance = player.m_21124_(vampirism_sunscreen);
        return effectInstance == null || effectInstance.m_19557_() <= 1;
    }
}

