/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item.crafting;

import com.google.gson.JsonObject;
import com.oblivioussp.spartanshields.init.ModRecipes;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class PoweredShieldUpgradeRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    private final ShapedRecipe internalRecipe;

    public PoweredShieldUpgradeRecipe(ShapedRecipe baseRecipe) {
        this.internalRecipe = baseRecipe;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        return this.internalRecipe.m_5818_(inv, level);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack resultStack = this.m_8043_(registryAccess).m_41777_();
        int feToTransfer = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            LazyOptional cap = stack.getCapability(ForgeCapabilities.ENERGY);
            if (!cap.isPresent()) continue;
            feToTransfer += ((IEnergyStorage)cap.resolve().orElseThrow()).getEnergyStored();
        }
        LazyOptional resultCap = resultStack.getCapability(ForgeCapabilities.ENERGY);
        int maxFE = ((IEnergyStorage)resultCap.resolve().orElseThrow()).getMaxEnergyStored();
        feToTransfer = Mth.m_14045_((int)feToTransfer, (int)0, (int)maxFE);
        resultStack.m_41784_().m_128405_("Energy", feToTransfer);
        return resultStack;
    }

    public boolean m_8004_(int width, int height) {
        return this.internalRecipe.m_8004_(width, height);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.internalRecipe.m_8043_(registryAccess);
    }

    public ResourceLocation m_6423_() {
        return this.internalRecipe.m_6423_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.POWERED_SHIELD_UPGRADE.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return this.internalRecipe.m_7457_((Container)inv);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.internalRecipe.m_7527_();
    }

    public boolean m_5598_() {
        return this.internalRecipe.m_5598_();
    }

    public String m_6076_() {
        return this.internalRecipe.m_6076_();
    }

    public ItemStack m_8042_() {
        return this.internalRecipe.m_8042_();
    }

    public int getRecipeWidth() {
        return this.internalRecipe.getRecipeWidth();
    }

    public int getRecipeHeight() {
        return this.internalRecipe.getRecipeHeight();
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static class Serializer
    implements RecipeSerializer<PoweredShieldUpgradeRecipe> {
        public PoweredShieldUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new PoweredShieldUpgradeRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json));
        }

        public PoweredShieldUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                return new PoweredShieldUpgradeRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer));
            }
            catch (Exception e) {
                Log.error("Failed to read a Powered Shield Upgrade Recipe from a packet!");
                throw e;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, PoweredShieldUpgradeRecipe recipe) {
            try {
                RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe.internalRecipe);
            }
            catch (Exception e) {
                Log.error("Failed to write a Powered Shield Upgrade Recipe to a packet!");
            }
        }
    }
}

