/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.screen.book.BookScreen;

public class TextComponentDataRenderer {
    public static String drawText(GuiGraphics graphics, int x, int y, int boxWidth, int boxHeight, TextComponentData[] data, int mouseX, int mouseY, Font fr, List<Component> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextComponentData item : data) {
            boolean mouseCheck;
            int box1W = 9999;
            Objects.requireNonNull(fr);
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null) continue;
            if (item.text.getString().equals("\n")) {
                atX = x;
                Objects.requireNonNull(fr);
                atY += 9;
                continue;
            }
            if (item.isParagraph) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            List<FormattedText> textLines = TextComponentDataRenderer.splitTextComponentBySize(item.text, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                if (lineNumber == textLines.size() - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                FormattedText textComponent = textLines.get(lineNumber);
                TextComponentDataRenderer.drawScaledTextComponent(graphics, fr, textComponent, atX, atY, item.dropShadow, item.scale);
                if (lineNumber < textLines.size() - 1) {
                    Objects.requireNonNull(fr);
                    atY += 9;
                    atX = x;
                }
                if (lineNumber != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.m_92724_(Language.m_128107_().m_5536_(textLines.get(textLines.size() - 1))) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            Objects.requireNonNull(fr);
            int box3H = (int)(f + 9.0f * item.scale);
            boolean bl = mouseCheck = mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H;
            if (item.tooltips != null && item.tooltips.length > 0) {
                if (BookScreen.debug) {
                    graphics.m_280024_(box1X, box1Y, box1W, box1H, -16711936, -16711936);
                    graphics.m_280024_(box2X, box2Y, box2W, box2H, -65536, -65536);
                    graphics.m_280024_(box3X, box3Y, box3W, box3H, -16776961, -16776961);
                    graphics.m_280024_(mouseX, mouseY, mouseX + 5, mouseY + 5, -65281, -256);
                }
                if (mouseCheck) {
                    tooltip.addAll(Arrays.asList(item.tooltips));
                }
            }
            if (item.action != null && !item.action.isEmpty() && mouseCheck) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                graphics.m_280056_(fr, "...", atX, atY, 0, item.dropShadow);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && !action.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237113_((String)("Action: " + action)).m_130940_(ChatFormatting.GRAY));
        }
        return action;
    }

    public static List<FormattedText> splitTextComponentBySize(Component textComponent, int width, int height, int firstWidth, Font fontRenderer, float scale) {
        ArrayList<Object> textLines;
        boolean needsWrap;
        block6: {
            block5: {
                int curWidth = (int)((float)fontRenderer.m_92852_((FormattedText)textComponent) * scale);
                Objects.requireNonNull(fontRenderer);
                int curHeight = (int)(9.0f * scale);
                needsWrap = false;
                textLines = new ArrayList<FormattedText>();
                Objects.requireNonNull(fontRenderer);
                if (curHeight == (int)(9.0f * scale) && curWidth > firstWidth) break block5;
                Objects.requireNonNull(fontRenderer);
                if (curHeight == (int)(9.0f * scale) || curWidth <= width) break block6;
            }
            needsWrap = true;
        }
        if (needsWrap) {
            textLines = new ArrayList(fontRenderer.m_92865_().m_92414_((FormattedText)textComponent, firstWidth, Style.f_131099_));
        } else {
            textLines.add((FormattedText)textComponent);
        }
        return textLines;
    }

    public static void drawScaledTextComponent(GuiGraphics graphics, Font font, FormattedText textComponent, float x, float y, boolean dropShadow, float scale) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        graphics.m_280649_(font, Language.m_128107_().m_5536_(textComponent), 0, 0, 0, dropShadow);
        poseStack.m_85849_();
    }
}

