/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record IntArrayLoadable(Loadable<Integer> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<int[]>
{
    @Override
    public int getLength(int[] array) {
        return array.length;
    }

    @Override
    public int[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new int[]{this.base.convert(element, key, context)};
    }

    @Override
    public int[] convertArray(JsonArray array, String key, TypedMap context) {
        int[] result = new int[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context);
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(int[] object) {
        return this.base.serialize(object[0]);
    }

    @Override
    public void serializeAll(JsonArray array, int[] object) {
        for (int element : object) {
            array.add(this.base.serialize(element));
        }
    }

    @Override
    public int[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        int[] array = new int[max];
        for (int i = 0; i < max; ++i) {
            array[i] = (Integer)this.base.decode(buffer, context);
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, int[] array) {
        buffer.m_130130_(array.length);
        for (int element : array) {
            this.base.encode(buffer, element);
        }
    }

    @Override
    public <P> LoadableField<int[], P> defaultField(String key, int[] defaultValue, boolean serializeDefault, Function<P, int[]> getter) {
        return new DefaultingField<int[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<int[], P> emptyField(String key, boolean serializeEmpty, Function<P, int[]> getter) {
        return this.defaultField(key, new int[0], serializeEmpty, getter);
    }
}

