/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.network.packet.SwingArmPacket;
import slimeknights.mantle.util.LogicHelper;

public class OffhandCooldownTracker
implements ICapabilityProvider {
    public static final ResourceLocation KEY = Mantle.getResource("offhand_cooldown");
    @Deprecated(forRemoval=true)
    public static final NonNullFunction<OffhandCooldownTracker, Float> COOLDOWN_TRACKER = OffhandCooldownTracker::getCooldown;
    public static final Capability<OffhandCooldownTracker> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<OffhandCooldownTracker>(){});
    private final LazyOptional<OffhandCooldownTracker> capabilityInstance = LazyOptional.of(() -> this);
    @Nullable
    private final Player player;
    private int lastCooldown = 0;
    private int attackReady = 0;
    private int enabled = 0;

    public static void init() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, OffhandCooldownTracker::attachCapability);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(OffhandCooldownTracker.class);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            event.addCapability(KEY, (ICapabilityProvider)new OffhandCooldownTracker(player));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == CAPABILITY ? this.capabilityInstance.cast() : LazyOptional.empty();
    }

    private int getTicksExisted() {
        if (this.player == null) {
            return 0;
        }
        return this.player.f_19797_;
    }

    @Deprecated(forRemoval=true)
    public boolean isEnabled() {
        return this.enabled > 0;
    }

    @Deprecated(forRemoval=true)
    public void setEnabled(boolean enable) {
        this.enabled = enable ? ++this.enabled : --this.enabled;
    }

    public void applyCooldown(int cooldown) {
        this.lastCooldown = cooldown;
        this.attackReady = this.getTicksExisted() + cooldown;
    }

    public float getCooldown() {
        int ticksExisted = this.getTicksExisted();
        if (ticksExisted > this.attackReady || this.lastCooldown == 0) {
            return 1.0f;
        }
        return Mth.m_14036_((float)((float)(this.lastCooldown + ticksExisted - this.attackReady) / (float)this.lastCooldown), (float)0.0f, (float)1.0f);
    }

    public boolean isAttackReady() {
        return this.getTicksExisted() + this.lastCooldown > this.attackReady;
    }

    @Nullable
    public static OffhandCooldownTracker get(Player player) {
        return (OffhandCooldownTracker)LogicHelper.orElseNull(player.getCapability(CAPABILITY));
    }

    public static float getCooldown(Player player) {
        OffhandCooldownTracker tracker = OffhandCooldownTracker.get(player);
        return tracker != null ? tracker.getCooldown() : 1.0f;
    }

    public static void applyCooldown(Player player, int cooldown) {
        OffhandCooldownTracker tracker = OffhandCooldownTracker.get(player);
        if (tracker != null) {
            tracker.applyCooldown(cooldown);
        }
    }

    public static boolean isAttackReady(Player player) {
        OffhandCooldownTracker tracker = OffhandCooldownTracker.get(player);
        return tracker == null || tracker.isAttackReady();
    }

    public static void applyCooldown(Player player, float attackSpeed, int cooldownTime) {
        OffhandCooldownTracker.applyCooldown(player, Math.round((float)cooldownTime / attackSpeed));
    }

    public static void swingHand(LivingEntity entity, InteractionHand hand, boolean updateSelf) {
        if (!entity.f_20911_ || entity.f_20913_ >= entity.m_21304_() / 2 || entity.f_20913_ < 0) {
            entity.f_20913_ = -1;
            entity.f_20911_ = true;
            entity.f_20912_ = hand;
            if (!entity.m_9236_().f_46443_) {
                SwingArmPacket packet = new SwingArmPacket((Entity)entity, hand);
                if (updateSelf) {
                    MantleNetwork.INSTANCE.sendToTrackingAndSelf(packet, (Entity)entity);
                } else {
                    MantleNetwork.INSTANCE.sendToTracking(packet, (Entity)entity);
                }
            }
        }
    }

    public OffhandCooldownTracker(@Nullable Player player) {
        this.player = player;
    }
}

