/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class ReversedListBuilder<E> {
    private final List<E> unpacked = new ArrayList();

    public void add(E data) {
        this.unpacked.add(data);
    }

    public int size() {
        return this.unpacked.size();
    }

    public void build(Consumer<E> consumer) {
        for (int i = this.unpacked.size() - 1; i >= 0; --i) {
            consumer.accept(this.unpacked.get(i));
        }
    }

    public static int size(ReversedListBuilder<? extends Collection<?>> builder) {
        return builder.unpacked.stream().mapToInt(Collection::size).sum();
    }

    public static <E> List<E> buildList(ReversedListBuilder<? extends Collection<E>> builder) {
        int size = ReversedListBuilder.size(builder);
        if (size == 0) {
            return List.of();
        }
        ArrayList listBuilder = new ArrayList(size);
        builder.build(listBuilder::addAll);
        return List.copyOf(listBuilder);
    }
}

