/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.network.chat.Component;

public class MemoryChecker
extends TimerTask {
    public static MemoryChecker INSTANCE;
    public List<MemoryCount> counts = new ArrayList<MemoryCount>();
    long lastlog;
    int logTimer;
    double lastUsed;
    long warnDelta;
    boolean ranHeapDump = false;
    boolean heapDumpEnabled;
    Timer timer;

    public static void start() {
        if (CrashUtils.SERVER_CONFIG.getMemoryChecker()) {
            INSTANCE = new MemoryChecker();
            INSTANCE.setup();
        }
    }

    public static void restart() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
        }
        if (CrashUtils.SERVER_CONFIG.getMemoryChecker()) {
            INSTANCE = new MemoryChecker();
            INSTANCE.setup();
        }
    }

    private void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.counts.clear();
    }

    public void setup() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.logTimer = CrashUtils.SERVER_CONFIG.getMemoryLogTimer() * 1000;
        this.warnDelta = CrashUtils.SERVER_CONFIG.getMemoryWarnDelta();
        this.heapDumpEnabled = CrashUtils.SERVER_CONFIG.getHeapDump();
        this.timer = new Timer("CU Memory Check Task", true);
        int time = CrashUtils.SERVER_CONFIG.getMemoryTimer() * 1000;
        this.timer.scheduleAtFixedRate((TimerTask)this, time, (long)time);
    }

    @Override
    public void run() {
        Runtime r = Runtime.getRuntime();
        MemoryCount count = new MemoryCount(r.maxMemory(), r.freeMemory(), r.totalMemory());
        if (this.shouldLog()) {
            this.counts.add(count);
            if (this.counts.size() > 100) {
                for (int i = 0; i < 20; ++i) {
                    this.counts.remove(this.counts.size() - 1);
                }
            }
        }
        double used = MemoryChecker.inMegaBytes(count.getMaximum() - count.getFree());
        double delta = used - this.lastUsed;
        String deltaString = String.format("%.2f", delta);
        if (delta > (double)this.warnDelta) {
            CrashUtils.LOGGER.info("Memory Spike " + deltaString + " MB");
        }
        this.lastUsed = used;
        double usedPerc = (float)count.getFree() / (float)count.getMaximum();
        if (usedPerc > (double)0.95f) {
            if (!this.ranHeapDump && CrashUtils.sparkLoaded) {
                CrashUtils.LOGGER.info("Running Spark Heapdump! LagSpike incoming!");
                CrashUtils.SERVER_CONFIG.disableHeapDump();
                this.ranHeapDump = true;
                CrashUtils.runNextTick(world -> {
                    world.m_7654_().m_6846_().m_240416_((Component)CommandUtils.CreateTextComponent("Running Heapdump. Massive Lagspike incoming!"), false);
                    world.m_7654_().m_129892_().m_230957_(world.m_7654_().m_129893_(), "/spark heapdump");
                });
            }
            CrashUtils.LOGGER.info("Memory full, using" + usedPerc + "% of memory");
        }
    }

    private boolean shouldLog() {
        if (this.lastlog + (long)this.logTimer < System.currentTimeMillis()) {
            this.lastlog = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static double inMegaBytes(long x) {
        double y = x;
        return y / 1024.0 / 1024.0;
    }

    public static double inGigaBytes(long x) {
        double y = x;
        return y / 1024.0 / 1024.0 / 1024.0;
    }

    public static class MemoryCount {
        private long maximum;
        private long free;
        private long total;

        public MemoryCount(long maximum, long free, long total) {
            this.maximum = maximum;
            this.free = free;
            this.total = total;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public long getFree() {
            return this.free;
        }

        public long getTotal() {
            return this.total;
        }
    }
}

