/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.blocks;

import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.common.entities.DecoSeatEntity;
import com.razz.decocraft.common.properties.DecoProperty;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3f;

public class DecoSeatBlock
extends DecocraftBlock {
    private final Map<Integer, Vector3f> sittingNodes = new HashMap<Integer, Vector3f>();

    public DecoSeatBlock(JsonContainer.Entry meta, BBModel model) {
        super(meta, model);
        model.outlinerFlatList.stream().filter(outliner -> outliner.name.equals("sitting_node")).flatMap(outliner -> ((BBModelParts.OutlinerGroup)outliner).children.stream()).filter(node -> node instanceof BBModelParts.OutlinerCube).forEach(node -> {
            BBModelParts.Element element = (BBModelParts.Element)model.uuidMap.get(((BBModelParts.OutlinerCube)node).uuid);
            Vector3f sittingNode = new Vector3f(0.0f, 0.0f, 0.0f);
            if (element.position != null) {
                sittingNode = new Vector3f(element.position.x / 16.0f * meta.scale, element.position.y / 16.0f * meta.scale, element.position.z / 16.0f * meta.scale);
            } else if (element.from != null) {
                sittingNode = new Vector3f(element.from.x / 16.0f * meta.scale, element.from.y / 16.0f * meta.scale, element.from.z / 16.0f * meta.scale);
            }
            this.sittingNodes.put(Integer.parseInt(element.name), sittingNode);
        });
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DecoProperty.FACING});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DecoProperty.FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player playerEntity, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        List seats;
        if (!world.f_46443_ && (seats = world.m_45976_(DecoSeatEntity.class, new AABB((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)blockPos.m_123341_() + 1.0, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 1.0))).isEmpty()) {
            Vector3f offset = this.sittingNodes.get(0);
            Direction direction = (Direction)blockState.m_61143_((Property)DecoProperty.FACING);
            DecoSeatEntity seat = new DecoSeatEntity(world, blockPos, switch (direction) {
                case Direction.NORTH -> new Vector3f(0.5f + offset.x(), -0.2f + offset.y(), 0.7f + offset.z());
                case Direction.SOUTH -> new Vector3f(0.5f + offset.x(), -0.2f + offset.y(), 0.7f - offset.z());
                case Direction.EAST -> new Vector3f(0.5f - offset.z(), -0.2f + offset.y(), 0.6f + offset.x());
                case Direction.WEST -> new Vector3f(0.5f + offset.z(), -0.2f + offset.y(), 0.6f + offset.x());
                default -> new Vector3f(0.5f + offset.x(), -0.2f + offset.y(), 0.7f + offset.z());
            });
            world.m_7967_((Entity)seat);
            playerEntity.m_7998_((Entity)seat, false);
        }
        return InteractionResult.SUCCESS;
    }
}

