/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeMod;
import ovh.corail.tombstone.effect.AquaticLifeEffect;
import ovh.corail.tombstone.effect.FeatherFallEffect;
import ovh.corail.tombstone.effect.FrostResistanceEffect;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModTriggers;

public final class GhostlyShapeEffect
extends TombstoneEffect {
    private static final String SWIM_MODIFIER = "6aef7405-aee9-4186-a57e-546c5e142a31";

    public GhostlyShapeEffect() {
        super(MobEffectCategory.NEUTRAL, -14445414);
        ForgeMod.SWIM_SPEED.ifPresent(attribute -> this.m_19472_((Attribute)attribute, SWIM_MODIFIER, 0.5, AttributeModifier.Operation.ADDITION));
        this.noAttributeScale();
    }

    @Override
    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!EntityHelper.isValidPlayer((Entity)entity)) {
            return;
        }
        if (!entity.m_9236_().m_5776_() && (entity.f_19862_ || entity.f_19863_) && !entity.m_9236_().m_6249_((Entity)entity, entity.m_20191_().m_82377_(0.1, 0.0, 0.1), EntityHelper::isEnemy).isEmpty()) {
            CallbackHandler.addFastCallback(() -> {
                EffectHelper.clearEffect(entity, this);
                ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)entity);
            });
            return;
        }
        if (TimeHelper.atInterval((Entity)entity, 20)) {
            EffectHelper.clearBadEffects(entity);
        }
        if (!entity.m_9236_().m_5776_()) {
            if (entity.m_21223_() < entity.m_21233_()) {
                entity.m_21153_(entity.m_21233_());
            }
            EntityHelper.resetNutrition((ServerPlayer)entity);
            AquaticLifeEffect.onApplyEffect(entity, amplifier);
        }
        FrostResistanceEffect.onApplyEffect(entity, amplifier);
        FeatherFallEffect.onApplyEffect(entity, amplifier);
    }
}

