/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import ovh.corail.tombstone.gui.ColorOptionSlider;
import ovh.corail.tombstone.gui.ProgressOption;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.helper.StyleType;

public class ColorSliderHandler
implements ScreenConfig.IHideable {
    private final Component title;
    private final Component info;
    private int r;
    private int g;
    private int b;
    private final BooleanConsumer dirty;
    private ColorOptionSlider button1;
    private ColorOptionSlider button2;
    private ColorOptionSlider button3;

    ColorSliderHandler(String title, int color, BooleanConsumer dirty) {
        this.title = Component.m_237115_((String)("tombstone.config." + title));
        this.info = Component.m_237115_((String)("tombstone.config." + title + ".tooltip")).m_6270_(StyleType.TOOLTIP_DESC);
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.dirty = dirty;
    }

    private int getMinColorR() {
        return this.g * 256 + this.b;
    }

    private int getMaxColorR() {
        return this.getMinColorR() + 0xFF0000;
    }

    private int getMinColorG() {
        return this.r * 65536 + this.b;
    }

    private int getMaxColorG() {
        return this.getMinColorG() + 65280;
    }

    private int getMinColorB() {
        return this.r * 65536 + this.g * 256;
    }

    private int getMaxColorB() {
        return this.getMinColorB() + 255;
    }

    public int getColor() {
        return 65536 * this.r + 256 * this.g + this.b;
    }

    Component getTitle() {
        return this.title;
    }

    Component getInfo() {
        return this.info;
    }

    public void createWidget(Consumer<ColorOptionSlider> adder, int x, int y, int width, int height) {
        this.button1 = new ColorOptionSlider(x, y, width, height, new ProgressOption(this.title + "_R", 0.0, 255.0, 1.0f, Double.valueOf(this.r), d -> {
            this.r = d.intValue();
        }, d -> Component.m_237113_((String)(this.title + "_R"))), this::getMinColorR, this::getMaxColorR, this.dirty);
        adder.accept(this.button1);
        this.button2 = new ColorOptionSlider(x, y + 6, width, height, new ProgressOption(this.title + "_G", 0.0, 255.0, 1.0f, Double.valueOf(this.g), d -> {
            this.g = d.intValue();
        }, d -> Component.m_237113_((String)(this.title + "_G"))), this::getMinColorG, this::getMaxColorG, this.dirty);
        adder.accept(this.button2);
        this.button3 = new ColorOptionSlider(x, y + 12, width, height, new ProgressOption(this.title + "_B", 0.0, 255.0, 1.0f, Double.valueOf(this.b), d -> {
            this.b = d.intValue();
        }, d -> Component.m_237113_((String)(this.title + "_B"))), this::getMinColorB, this::getMaxColorB, this.dirty);
        adder.accept(this.button3);
    }

    @Override
    public void show() {
        this.button3.f_93624_ = true;
        this.button3.f_93623_ = true;
        this.button2.f_93624_ = true;
        this.button2.f_93623_ = true;
        this.button1.f_93624_ = true;
        this.button1.f_93623_ = true;
    }

    @Override
    public void hide() {
        this.button3.f_93624_ = false;
        this.button3.f_93623_ = false;
        this.button2.f_93624_ = false;
        this.button2.f_93623_ = false;
        this.button1.f_93624_ = false;
        this.button1.f_93623_ = false;
    }
}

