/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public final class GraveGuardianItemInHandLayer
extends ItemInHandLayer<GraveGuardian, SkeletonModel<GraveGuardian>> {
    private static final Supplier<ItemStack> HALLOWEEN_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.f_42431_));
    private static final Supplier<ItemStack> CHRISTMAS_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.villager_gift));
    private static final Supplier<ItemStack> DEFAULT_MAINHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)Items.f_42393_));
    private static final Supplier<ItemStack> HALLOWEEN_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.advancement.get((Object)ItemAdvancement.IconType.LANTERN)));
    private static final Supplier<ItemStack> CHRISTMAS_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.christmas_gift));
    private static final Supplier<ItemStack> DEFAULT_OFFHAND = Suppliers.memoize(() -> new ItemStack((ItemLike)ModItems.advancement.get((Object)ItemAdvancement.IconType.SOUL_LANTERN)));

    public GraveGuardianItemInHandLayer(RenderLayerParent<GraveGuardian, SkeletonModel<GraveGuardian>> parent, ItemInHandRenderer itemInHandRenderer) {
        super(parent, itemInHandRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GraveGuardian graveGuardian, float p_117208_, float p_117209_, float p_117210_, float p_117211_, float p_117212_, float p_117213_) {
        poseStack.m_85836_();
        this.m_117184_((LivingEntity)graveGuardian, this.getMainHand(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferSource, 0xF000F0);
        this.m_117184_((LivingEntity)graveGuardian, this.getOffHand(), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferSource, 0xF000F0);
        poseStack.m_85849_();
    }

    private ItemStack getMainHand() {
        return (TimeHelper.isDateAroundHalloween() ? HALLOWEEN_MAINHAND : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_MAINHAND : DEFAULT_MAINHAND)).get();
    }

    private ItemStack getOffHand() {
        return (TimeHelper.isDateAroundHalloween() ? HALLOWEEN_OFFHAND : (TimeHelper.isDateAroundChristmas() ? CHRISTMAS_OFFHAND : DEFAULT_OFFHAND)).get();
    }
}

