/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;

public class BackpackUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapedRecipe compose;

    public BackpackUpgradeRecipe(ShapedRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.getRecipeWidth(), compose.getRecipeHeight(), compose.m_7527_(), compose.m_8043_());
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack upgradedBackpack = super.m_5874_(inv);
        this.getBackpack(inv).flatMap(backpack -> Optional.ofNullable(backpack.m_41783_())).ifPresent(tag -> upgradedBackpack.m_41751_(tag.m_6426_()));
        upgradedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            BackpackItem backpackItem = (BackpackItem)upgradedBackpack.m_41720_();
            wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
        });
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBackpack(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (!(slotStack.m_41720_() instanceof BackpackItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.BACKPACK_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, BackpackUpgradeRecipe> {
        public Serializer() {
            super(BackpackUpgradeRecipe::new, RecipeSerializer.f_44076_);
        }
    }
}

