/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FurnaceRecipeBuilder
extends AbstractItemStackRecipeBuilder<FurnaceRecipeBuilder> {
    private static final Logger logger = LogManager.getLogger();
    private Ingredient ingredient;
    private float experience = 0.0f;
    private int cookingTime = 200;

    protected FurnaceRecipeBuilder(RecipeSerializer<?> serializer, ResourceLocation id, ItemStack result) {
        super(serializer, id, result);
    }

    public static FurnaceRecipeBuilder smelting(ItemLike result) {
        return FurnaceRecipeBuilder.smelting(result, 1);
    }

    public static FurnaceRecipeBuilder smelting(ItemLike result, int count) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder smelting(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smelting(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder smelting(ItemStack result) {
        return FurnaceRecipeBuilder.smelting(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static FurnaceRecipeBuilder smelting(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((RecipeSerializer<?>)RecipeSerializer.f_44091_, id, result).cookingTime(200);
    }

    public static FurnaceRecipeBuilder blasting(ItemLike result) {
        return FurnaceRecipeBuilder.blasting(result, 1);
    }

    public static FurnaceRecipeBuilder blasting(ItemLike result, int count) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder blasting(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.blasting(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder blasting(ItemStack result) {
        return FurnaceRecipeBuilder.blasting(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static FurnaceRecipeBuilder blasting(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((RecipeSerializer<?>)RecipeSerializer.f_44092_, id, result).cookingTime(100);
    }

    public static FurnaceRecipeBuilder smoking(ItemLike result) {
        return FurnaceRecipeBuilder.smoking(result, 1);
    }

    public static FurnaceRecipeBuilder smoking(ItemLike result, int count) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder smoking(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.smoking(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder smoking(ItemStack result) {
        return FurnaceRecipeBuilder.smoking(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static FurnaceRecipeBuilder smoking(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((RecipeSerializer<?>)RecipeSerializer.f_44093_, id, result).cookingTime(100);
    }

    public static FurnaceRecipeBuilder campfire(ItemLike result) {
        return FurnaceRecipeBuilder.campfire(result, 1);
    }

    public static FurnaceRecipeBuilder campfire(ItemLike result, int count) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder campfire(ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.campfire(new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder campfire(ItemStack result) {
        return FurnaceRecipeBuilder.campfire(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static FurnaceRecipeBuilder campfire(ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder((RecipeSerializer<?>)RecipeSerializer.f_44094_, id, result).cookingTime(600);
    }

    public static FurnaceRecipeBuilder custom(RecipeSerializer<?> serializer, ItemLike result) {
        return FurnaceRecipeBuilder.custom(serializer, result, 1);
    }

    public static FurnaceRecipeBuilder custom(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return FurnaceRecipeBuilder.custom(serializer, new ItemStack(result, count));
    }

    public static FurnaceRecipeBuilder custom(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return FurnaceRecipeBuilder.custom(serializer, new ItemStack(result, count), id);
    }

    public static FurnaceRecipeBuilder custom(RecipeSerializer<?> serializer, ItemStack result) {
        return FurnaceRecipeBuilder.custom(serializer, result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()));
    }

    public static FurnaceRecipeBuilder custom(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return new FurnaceRecipeBuilder(serializer, id, result);
    }

    public FurnaceRecipeBuilder ingredient(TagKey<Item> tag) {
        this.addAutoCriteria(tag);
        this.ingredient = Ingredient.m_204132_(tag);
        return this;
    }

    public FurnaceRecipeBuilder ingredient(ItemLike item) {
        this.addAutoCriteria(item);
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public FurnaceRecipeBuilder ingredient(Ingredient ingredient) {
        if (this.generateCriteria) {
            logger.warn("Criteria not automatically generated for raw ingredient.", new Throwable("Here, have a stack trace"));
        }
        this.ingredient = ingredient;
        return this;
    }

    public FurnaceRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public FurnaceRecipeBuilder cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    @Override
    public AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe _build() {
        return new FinishedFurnaceRecipe();
    }

    public class FinishedFurnaceRecipe
    extends AbstractItemStackRecipeBuilder.AbstractItemStackFinishedRecipe {
        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.add("ingredient", FurnaceRecipeBuilder.this.ingredient.m_43942_());
            json.addProperty("experience", (Number)Float.valueOf(FurnaceRecipeBuilder.this.experience));
            json.addProperty("cookingtime", (Number)FurnaceRecipeBuilder.this.cookingTime);
        }
    }
}

