/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.internal.ItemFileRenderer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class RenderItemToFileCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ccl").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"render_held_to_file").then(Commands.m_82129_((String)"resolution", (ArgumentType)IntegerArgumentType.integer((int)16)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToFile((CommandContext<CommandSourceStack>)e, RenderItemToFileCommand.getResolution((CommandContext<CommandSourceStack>)e)))))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToFile((CommandContext<CommandSourceStack>)e, 512))))).then(Commands.m_82127_((String)"render_held_to_gif").then(Commands.m_82129_((String)"fps", (ArgumentType)IntegerArgumentType.integer((int)5, (int)75)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"resolution", (ArgumentType)IntegerArgumentType.integer((int)16)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToGif((CommandContext<CommandSourceStack>)e, RenderItemToFileCommand.getResolution((CommandContext<CommandSourceStack>)e)))))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(e -> RenderItemToFileCommand.renderToGif((CommandContext<CommandSourceStack>)e, 512)))))));
    }

    private static int renderToFile(CommandContext<CommandSourceStack> ctx, int resolution) {
        Path path = RenderItemToFileCommand.getPath(ctx, "png");
        ItemStack held = RenderItemToFileCommand.getHeldItem();
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237113_((String)("Queued item render to file: " + path)), false);
        ItemFileRenderer.addRenderTask(held, path, resolution);
        return 0;
    }

    private static int renderToGif(CommandContext<CommandSourceStack> ctx, int resolution) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        int fps = IntegerArgumentType.getInteger(ctx, (String)"fps");
        int duration = IntegerArgumentType.getInteger(ctx, (String)"duration");
        Path path = RenderItemToFileCommand.getPath(ctx, "gif");
        ItemStack held = RenderItemToFileCommand.getHeldItem();
        src.m_81354_((Component)Component.m_237113_((String)("Queued item render to gif: " + path)), false);
        ItemFileRenderer.addGifRenderTask(held, path, resolution, fps, duration);
        return 0;
    }

    private static Path getPath(CommandContext<CommandSourceStack> ctx, String extension) {
        String str = StringArgumentType.getString(ctx, (String)"name");
        if (str.contains("..")) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"'..' is not allowed in name."));
        }
        return Paths.get("exports", str + "." + extension);
    }

    public static int getResolution(CommandContext<CommandSourceStack> ctx) {
        int res = IntegerArgumentType.getInteger(ctx, (String)"resolution");
        if ((res & res - 1) != 0) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Resolution must be a power of 2. 16, 32, 64..."));
        }
        return res;
    }

    private static ItemStack getHeldItem() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_()) {
            held = player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (held.m_41619_()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"You are not holding anything."));
        }
        return held;
    }
}

