/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public abstract class VoidStorageData<T>
extends SavedData {
    protected final Map<VoidMotorNetworkHandler.NetworkKey, T> storages = new HashMap<VoidMotorNetworkHandler.NetworkKey, T>();

    public T computeStorageIfAbsent(VoidMotorNetworkHandler.NetworkKey key, Function<VoidMotorNetworkHandler.NetworkKey, T> function) {
        return this.storages.computeIfAbsent(key, function);
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, Function<T, Boolean> isEmpty, Function<T, CompoundTag> serializeNBT) {
        this.storages.forEach((key, inventory) -> {
            if (!((Boolean)isEmpty.apply(inventory)).booleanValue()) {
                tag.m_128365_(key.toString(), (Tag)serializeNBT.apply(inventory));
            }
        });
        return tag;
    }

    public static <T, S extends VoidStorageData<T>> S load(CompoundTag tag, Supplier<S> storageDataSupplier, Function<VoidMotorNetworkHandler.NetworkKey, T> storageSupplier, BiConsumer<T, CompoundTag> deserializeNBT) {
        VoidStorageData data = (VoidStorageData)((Object)storageDataSupplier.get());
        tag.m_128431_().forEach(k -> {
            VoidMotorNetworkHandler.NetworkKey key = VoidMotorNetworkHandler.NetworkKey.fromString(k);
            Object inventory = storageSupplier.apply(key);
            deserializeNBT.accept(inventory, tag.m_128469_(k));
            data.storages.put(key, inventory);
        });
        return (S)((Object)data);
    }
}

