/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.battery;

import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import me.duquee.createutilities.networking.CUPackets;
import me.duquee.createutilities.networking.packets.VoidBatteryUpdatePacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.network.PacketDistributor;

public class VoidBattery
extends EnergyStorage {
    private final VoidMotorNetworkHandler.NetworkKey key;

    public VoidBattery(VoidMotorNetworkHandler.NetworkKey key) {
        super(32000, 4096, 4096);
        this.key = key;
    }

    public boolean isEmpty() {
        return this.energy == 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int inserted = super.receiveEnergy(maxReceive, simulate);
        if (inserted != 0) {
            this.onContentsChanged();
        }
        return inserted;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (extracted != 0) {
            this.onContentsChanged();
        }
        return extracted;
    }

    private void onContentsChanged() {
        if (CreateUtilities.VOID_BATTERIES_DATA != null) {
            CreateUtilities.VOID_BATTERIES_DATA.m_77762_();
        }
        CUPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new VoidBatteryUpdatePacket(this.key, this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("Energy", (long)this.energy);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energy = nbt.m_128451_("Energy");
    }
}

