/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.BlockEntities;

import com.mowmaster.mowlib.BlockEntities.BaseBuiltMachineBlockEntity;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BaseBuiltFueledMachineBlockEntity
extends BaseBuiltMachineBlockEntity {
    private LazyOptional<IItemHandler> allowedInputsHandler = LazyOptional.of(this::createAllowedInputsHandler);
    private List<ItemStack> stacksListAllowedInputsHandler = new ArrayList<ItemStack>();
    private int burnTime = 0;
    private int currentCookTime = 0;
    private int maxCookTime = 0;
    private float xpForOutput = 0.0f;
    private ItemStack outputItemStack = ItemStack.f_41583_;
    private boolean isLit = false;

    public BaseBuiltFueledMachineBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public void update() {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        this.f_58857_.m_7260_(this.getPos(), state, state, 3);
        this.m_6596_();
    }

    public RecipeType getRecipeTypeForBlock() {
        return RecipeType.f_44108_;
    }

    private IItemHandler createAllowedInputsHandler() {
        final int slots = 2;
        return new ItemStackHandler(slots){

            protected void onLoad() {
                if (this.getSlots() < slots) {
                    for (int i = 0; i < this.getSlots(); ++i) {
                        BaseBuiltFueledMachineBlockEntity.this.stacksListAllowedInputsHandler.add(i, this.getStackInSlot(i));
                    }
                    this.setSize(BaseBuiltFueledMachineBlockEntity.this.getRepairListStacks().size());
                    for (int j = 0; j < BaseBuiltFueledMachineBlockEntity.this.stacksListAllowedInputsHandler.size(); ++j) {
                        this.setStackInSlot(j, BaseBuiltFueledMachineBlockEntity.this.stacksListAllowedInputsHandler.get(j));
                    }
                }
                super.onLoad();
            }

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return 1;
                }
                if (slot == 1) {
                    return 4;
                }
                return 0;
            }

            protected void onContentsChanged(int slot) {
                if (BaseBuiltFueledMachineBlockEntity.this.stacksListAllowedInputsHandler.size() <= 0) {
                    BaseBuiltFueledMachineBlockEntity.this.update();
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BaseBuiltFueledMachineBlockEntity.this.isAllowedInputItemForMachineSlot(slot, stack);
            }
        };
    }

    @Nullable
    public Recipe<Container> getRecipe(Level world, ItemStack stackIn) {
        if (world == null) {
            return null;
        }
        Container inv = MowLibContainerUtils.getContainer(1);
        inv.m_6836_(-1, stackIn);
        RecipeManager recipeManager = world.m_7465_();
        if (this.getRecipeTypeForBlock() == RecipeType.f_44109_) {
            List optional = recipeManager.m_44056_(RecipeType.f_44109_, inv, world);
            return this.m_58904_() != null ? (optional.size() > 0 ? (Recipe)optional.stream().findFirst().get() : null) : null;
        }
        if (this.getRecipeTypeForBlock() == RecipeType.f_44110_) {
            List optional2 = recipeManager.m_44056_(RecipeType.f_44110_, inv, world);
            return this.m_58904_() != null ? (optional2.size() > 0 ? (Recipe)optional2.stream().findFirst().get() : null) : null;
        }
        if (this.getRecipeTypeForBlock() == RecipeType.f_44108_) {
            List optional1 = recipeManager.m_44056_(RecipeType.f_44108_, inv, world);
            return this.m_58904_() != null ? (optional1.size() > 0 ? (Recipe)optional1.stream().findFirst().get() : null) : null;
        }
        return null;
    }

    public ItemStack getProcessResults(Recipe<Container> recipe) {
        return recipe == null ? ItemStack.f_41583_ : recipe.m_8043_();
    }

    public float getProcessResultsXP(Recipe<Container> recipe) {
        if (recipe instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe recipeCook = (AbstractCookingRecipe)recipe;
            return recipe == null ? 0.0f : recipeCook.m_43750_();
        }
        return 0.0f;
    }

    public int getProcessCookTime(Recipe<Container> recipe) {
        if (recipe instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe recipeCook = (AbstractCookingRecipe)recipe;
            return recipe == null ? 0 : recipeCook.m_43753_();
        }
        return 200;
    }

    public boolean isAllowedInputItemForMachineSlot(int slot, ItemStack stack) {
        if (slot == 0 && !stack.m_41720_().equals(Items.f_42448_) && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)this.getRecipeTypeForBlock()) > 0 && this.getInputItemInSlot(0).m_41613_() < 1) {
            return true;
        }
        return slot == 1 && this.getRecipe(this.m_58904_(), stack) != null;
    }

    public int getAllowedInputSlotForMachine(ItemStack stack) {
        if (!stack.m_41720_().equals(Items.f_42448_) && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)this.getRecipeTypeForBlock()) > 0 && this.getInputItemInSlot(0).m_41613_() < 1) {
            return 0;
        }
        if (this.getRecipe(this.m_58904_(), stack) != null) {
            return 1;
        }
        return -1;
    }

    public ItemStack addInputItem(ItemStack inputItemFromBlock, boolean simulate) {
        IItemHandler aih = (IItemHandler)this.allowedInputsHandler.orElse(null);
        ItemStack insertedItem = inputItemFromBlock.m_41777_();
        if (aih != null) {
            int slot = this.getAllowedInputSlotForMachine(insertedItem);
            if (slot == -1) {
                return inputItemFromBlock;
            }
            if (aih.isItemValid(slot, insertedItem) && slot < aih.getSlots() && aih.insertItem(slot, insertedItem, true).m_41613_() != inputItemFromBlock.m_41613_()) {
                if (!simulate) {
                    if (slot == 1 && this.getInputItemInSlot(slot).m_41619_()) {
                        Recipe<Container> recipe = this.getRecipe(this.m_58904_(), insertedItem);
                        this.outputItemStack = this.getProcessResults(recipe);
                        this.xpForOutput = this.getProcessResultsXP(recipe);
                        this.maxCookTime = this.getProcessCookTime(recipe);
                    }
                    return aih.insertItem(slot, insertedItem, false);
                }
                return aih.insertItem(slot, insertedItem, true);
            }
        }
        return inputItemFromBlock;
    }

    public ItemStack getInputItemInSlot(int slot) {
        ItemStack returner = ItemStack.f_41583_;
        IItemHandler aih = (IItemHandler)this.allowedInputsHandler.orElse(null);
        if (aih != null) {
            returner = aih.getStackInSlot(slot);
        }
        return returner;
    }

    public ItemStack removeItemFromSlot(int slot, int amount, boolean simulate) {
        ItemStack returner = ItemStack.f_41583_;
        IItemHandler aih = (IItemHandler)this.allowedInputsHandler.orElse(null);
        if (aih != null && !(returner = aih.extractItem(slot, amount, true)).m_41619_()) {
            if (!simulate) {
                returner = aih.extractItem(slot, amount, simulate);
            }
            if (slot == 1 && this.getInputItemInSlot(slot).m_41619_()) {
                this.outputItemStack = ItemStack.f_41583_;
                this.xpForOutput = 0.0f;
                this.maxCookTime = 0;
            }
        }
        return returner;
    }

    public boolean isFurnaceLit() {
        return this.isLit;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int calcFuelBurnTime() {
        ItemStack burnSlot = this.getInputItemInSlot(0);
        if (!burnSlot.m_41619_()) {
            return ForgeHooks.getBurnTime((ItemStack)burnSlot, (RecipeType)this.getRecipeTypeForBlock());
        }
        return 0;
    }

    public void addToBurnTime() {
        ItemStack burnSlot = this.getInputItemInSlot(0);
        if (!burnSlot.m_41619_() && !this.removeItemFromSlot(0, 1, true).m_41619_()) {
            this.changeBurnTime(this.calcFuelBurnTime(), true);
            this.setLit(true);
            this.removeItemFromSlot(0, 1, false);
        }
    }

    public void setLit(boolean isLitValue) {
        this.isLit = isLitValue;
    }

    public void setBurnTime(int setAmount) {
        this.burnTime = setAmount;
    }

    public void changeBurnTime(int amount, boolean increase) {
        this.burnTime = increase ? (this.burnTime += amount) : (this.burnTime -= amount);
    }

    public ItemStack getOutputItem() {
        return this.outputItemStack;
    }

    public float getXPOutput() {
        return this.xpForOutput;
    }

    public int getMaxCookTime() {
        return this.maxCookTime;
    }

    public int getCurrentCookTime() {
        return this.currentCookTime;
    }

    public void setCurrentCookTime(int setAmount) {
        this.currentCookTime = setAmount;
    }

    public void changeCurrentCookTime(int amount, boolean increase) {
        this.currentCookTime = increase ? (this.currentCookTime += amount) : (this.currentCookTime -= amount);
    }

    public void spawnItemStackOutput(Level worldIn, double x, double y, double z, ItemStack stack) {
        Random RANDOM = new Random();
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!stack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(worldIn, d3, d4, d5, stack.m_41620_(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.m_6001_(0.1 * (double)RANDOM.nextInt(-5, 6), 0.1 * (double)RANDOM.nextInt(5), 0.1 * (double)RANDOM.nextInt(-5, 6));
            worldIn.m_7967_((Entity)itementity);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.m_58904_().m_5776_()) {
            if (this.m_58904_().m_46467_() % 20L == 0L) {
                if (this.getBurnTime() > 0) {
                    this.changeBurnTime(20, false);
                    if (this.getBurnTime() <= 5) {
                        this.addToBurnTime();
                    }
                    if (this.getBurnTime() <= 0) {
                        this.setLit(false);
                        this.update();
                    }
                    if (!this.removeItemFromSlot(1, 1, true).m_41619_()) {
                        this.changeCurrentCookTime(20, true);
                        if (this.getCurrentCookTime() >= this.getMaxCookTime()) {
                            this.setCurrentCookTime(0);
                            this.spawnItemStackOutput(this.m_58904_(), this.getPos().m_123341_(), this.getPos().m_123342_() + 1, this.getPos().m_123343_(), this.getOutputItem().m_41777_());
                            this.removeItemFromSlot(1, 1, false);
                            if (this.getXPOutput() > 0.0f) {
                                Random rand = new Random();
                                ExperienceOrb xpEntity = new ExperienceOrb(this.f_58857_, (double)this.getPos().m_123341_(), (double)(this.getPos().m_123342_() + 1), (double)this.getPos().m_123343_(), (int)this.getXPOutput());
                                xpEntity.m_6001_(0.1 * (double)rand.nextInt(5), 0.1 * (double)rand.nextInt(5), 0.1 * (double)rand.nextInt(5));
                                this.m_58904_().m_7967_((Entity)xpEntity);
                            }
                        }
                    }
                } else if (!this.getInputItemInSlot(0).m_41619_()) {
                    this.addToBurnTime();
                } else if (this.getCurrentCookTime() > 0) {
                    this.changeCurrentCookTime(20, false);
                }
            }
            if (this.m_58904_().m_46467_() % 69L == 0L && this.isFurnaceLit()) {
                this.m_58904_().m_5594_(null, this.getPos(), SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void dropInputsItems(Level worldIn, BlockPos pos) {
        IItemHandler h = (IItemHandler)this.allowedInputsHandler.orElse(null);
        for (int i = 0; i < h.getSlots(); ++i) {
            MowLibItemUtils.spawnItemStack(worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), h.getStackInSlot(i));
        }
    }

    @Override
    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        CompoundTag allowedInputTag = p_155245_.m_128469_("allowed_inputs");
        this.allowedInputsHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)allowedInputTag));
        if (p_155245_.m_128441_("output_itemstack")) {
            CompoundTag invTag = p_155245_.m_128469_("output_itemstack");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            this.outputItemStack = handler.getStackInSlot(0);
        }
        this.burnTime = p_155245_.m_128451_("burnTime");
        this.currentCookTime = p_155245_.m_128451_("currentCookTime");
        this.maxCookTime = p_155245_.m_128451_("maxCookTime");
        this.xpForOutput = p_155245_.m_128457_("xpForOutput");
        this.isLit = p_155245_.m_128471_("isLit");
    }

    @Override
    public CompoundTag save(CompoundTag p_58888_) {
        super.save(p_58888_);
        this.allowedInputsHandler.ifPresent(h -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)h).serializeNBT();
            p_58888_.m_128365_("allowed_inputs", (Tag)compound);
        });
        CompoundTag compoundStorage = new CompoundTag();
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(1);
        handler.setStackInSlot(0, this.outputItemStack);
        compoundStorage = handler.serializeNBT();
        p_58888_.m_128365_("output_itemstack", (Tag)compoundStorage);
        p_58888_.m_128405_("burnTime", this.burnTime);
        p_58888_.m_128405_("currentCookTime", this.currentCookTime);
        p_58888_.m_128405_("maxCookTime", this.maxCookTime);
        p_58888_.m_128350_("xpForOutput", this.xpForOutput);
        p_58888_.m_128379_("isLit", this.isLit);
        return p_58888_;
    }
}

