/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Blocks.BaseBlocks;

import com.mowmaster.mowlib.Items.ColorApplicator;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.api.IColorableBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BaseColoredBlock
extends Block
implements IColorableBlock {
    public BaseColoredBlock(BlockBehaviour.Properties p_152915_) {
        super(p_152915_);
        this.m_49959_(MowLibColorReference.addColorToBlockState(this.m_49966_(), 0xFFFFFF));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56120_) {
        p_56120_.m_61104_(new Property[]{COLOR_RED}).m_61104_(new Property[]{COLOR_GREEN}).m_61104_(new Property[]{COLOR_BLUE});
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext p_56089_) {
        BlockState blockstate = p_56089_.m_43725_().m_8055_(p_56089_.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int getColor = MowLibColorReference.getColorFromStateInt(blockstate);
            return MowLibColorReference.addColorToBlockState(this.m_49966_(), getColor);
        }
        return super.m_5573_(p_56089_);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack picked = state.m_60734_().m_7397_(world, pos, state);
        int getColor = MowLibColorReference.getColorFromStateInt(state);
        return MowLibColorReference.addColorToItemStack(picked, getColor);
    }

    public void m_6402_(Level p_49847_, BlockPos p_49848_, BlockState p_49849_, @javax.annotation.Nullable LivingEntity p_49850_, ItemStack p_49851_) {
        if (p_49850_ instanceof Player) {
            Player player = (Player)p_49850_;
            if (player.m_21206_().m_41720_() instanceof ColorApplicator) {
                int getColor = MowLibColorReference.getColorFromItemStackInt(player.m_21206_());
                BlockState newState = MowLibColorReference.addColorToBlockState(p_49849_, getColor);
                p_49847_.m_7731_(p_49848_, newState, 3);
            } else {
                int getColor = MowLibColorReference.getColorFromItemStackInt(p_49851_);
                BlockState newState = MowLibColorReference.addColorToBlockState(p_49849_, getColor);
                p_49847_.m_7731_(p_49848_, newState, 3);
            }
        }
        super.m_6402_(p_49847_, p_49848_, p_49849_, p_49850_, p_49851_);
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        List DYES = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes"))).stream().toList();
        ItemStack itemInHand = p_60506_.m_21205_();
        ItemStack itemInOffHand = p_60506_.m_21206_();
        if (p_60506_.m_21120_(p_60507_).m_41720_() instanceof ColorApplicator) {
            int getColor = MowLibColorReference.getColorFromItemStackInt(p_60506_.m_21120_(p_60507_));
            int currentColor = MowLibColorReference.getColorFromStateInt(p_60503_);
            if (currentColor != getColor) {
                BlockState newState = MowLibColorReference.addColorToBlockState(p_60503_, getColor);
                p_60504_.m_7731_(p_60505_, newState, 3);
                return InteractionResult.SUCCESS;
            }
            Component sameColor = MowLibMessageUtils.getMowLibComponentLocalized(".recolor.message_sameColor", ChatFormatting.RED);
            if (p_60504_.f_46443_) {
                p_60506_.m_5661_(sameColor, true);
            }
            return InteractionResult.FAIL;
        }
        if (DYES.contains(itemInOffHand.m_41720_())) {
            int getColor = MowLibColorReference.getColorFromDyeInt(itemInOffHand);
            int currentColor = MowLibColorReference.getColorFromStateInt(p_60503_);
            if (currentColor != getColor) {
                BlockState newState = MowLibColorReference.addColorToBlockState(p_60503_, getColor);
                p_60504_.m_7731_(p_60505_, newState, 3);
                return InteractionResult.SUCCESS;
            }
            Component sameColor = MowLibMessageUtils.getMowLibComponentLocalized(".recolor.message_sameColor", ChatFormatting.RED);
            if (p_60504_.f_46443_) {
                p_60506_.m_5661_(sameColor, true);
            }
            return InteractionResult.FAIL;
        }
        return super.m_6227_(p_60503_, p_60504_, p_60505_, p_60506_, p_60507_, p_60508_);
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        if (p_60537_.m_60734_() instanceof BaseColoredBlock) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ItemStack itemstack = new ItemStack((ItemLike)this);
            int getColor = MowLibColorReference.getColorFromStateInt(p_60537_);
            ItemStack newStack = MowLibColorReference.addColorToItemStack(itemstack, getColor);
            newStack.m_41764_(1);
            stacks.add(newStack);
            return stacks;
        }
        return super.m_7381_(p_60537_, p_60538_);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return true;
    }

    public void m_5871_(ItemStack p_49816_, @Nullable BlockGetter p_49817_, List<Component> p_49818_, TooltipFlag p_49819_) {
        super.m_5871_(p_49816_, p_49817_, p_49818_, p_49819_);
    }
}

