/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Compat.JEI.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mowmaster.mowlib.Compat.JEI.JEIRecipeTypes;
import com.mowmaster.mowlib.Items.EffectItemBase;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.Recipes.MobEffectColorRecipe;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import java.util.Map;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EffectCraftingRecipeCategory
implements IRecipeCategory<MobEffectColorRecipe> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)DeferredRegisterItems.ICON_DUST.get());

    public EffectCraftingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("mowlib", "textures/gui/jei/effect_crafting.png"), 0, 0, 64, 64);
        this.localizedName = Component.m_237115_((String)"mowlib.jei.effect_crafting");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack);
    }

    public RecipeType<MobEffectColorRecipe> getRecipeType() {
        return JEIRecipeTypes.EFFECT_CRAFING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public MobEffect getRandomNegativeEffect() {
        Random rand = new Random();
        Map NEGEFFECT = Map.ofEntries(Map.entry(0, MobEffects.f_19594_), Map.entry(1, MobEffects.f_19610_), Map.entry(2, MobEffects.f_19619_), Map.entry(3, MobEffects.f_19612_), Map.entry(4, MobEffects.f_19602_), Map.entry(5, MobEffects.f_19620_), Map.entry(6, MobEffects.f_19599_), Map.entry(7, MobEffects.f_19604_), Map.entry(8, MobEffects.f_19614_), Map.entry(9, MobEffects.f_19597_), Map.entry(10, MobEffects.f_19590_), Map.entry(11, MobEffects.f_19613_), Map.entry(12, MobEffects.f_19615_));
        return NEGEFFECT.getOrDefault(rand.nextInt(13), MobEffects.f_19612_);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MobEffectColorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 24, 5).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 24).addItemStack(MowLibColorReference.addColorToItemStack(new ItemStack((ItemLike)DeferredRegisterItems.ICON_DUST.get()), recipe.getResultEffectColor()).m_41714_((Component)Component.m_237115_((String)("mowlib" + MowLibColorReference.getColorName(recipe.getResultEffectColor())))));
        ItemStack returner = MowLibColorReference.addColorToItemStack(new ItemStack((ItemLike)DeferredRegisterItems.ICON_EFFECT.get()), recipe.getResultEffectColor());
        MobEffectInstance effect = recipe.getResultEffectName() == "" ? new MobEffectInstance(this.getRandomNegativeEffect()) : new MobEffectInstance((MobEffect)Registry.f_122823_.m_6612_(new ResourceLocation(recipe.getResultEffectName())).get());
        EffectItemBase.setEffectToItem(returner, effect);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 43, 24).addItemStack(returner);
    }

    public void draw(MobEffectColorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
    }
}

