/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeAbstractMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MowLibItemUtils {
    public static LazyOptional<IItemHandler> findItemHandlerAtPos(Level world, BlockPos pos, boolean allowCart) {
        LazyOptional cap;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap = neighbourTile.getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return cap;
        }
        if (allowCart) {
            if (RailBlock.m_49364_((Level)world, (BlockPos)pos)) {
                LazyOptional cap2;
                list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof IForgeAbstractMinecart);
                if (!list.isEmpty() && (cap2 = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
                    return cap2;
                }
            } else {
                LazyOptional cap3;
                list = world.m_6443_(Entity.class, new AABB(pos.m_7494_()), entity -> entity instanceof Boat);
                if (!list.isEmpty() && (cap3 = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
                    return cap3;
                }
            }
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPos(Level world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(ForgeCapabilities.ITEM_HANDLER, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof ContainerEntity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static void spawnItemStack(Level worldIn, double x, double y, double z, ItemStack stack) {
        Random RANDOM = new Random();
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!stack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(worldIn, d3, d4, d5, stack.m_41620_(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.m_6001_(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            worldIn.m_7967_((Entity)itementity);
        }
    }

    public static void damageItem(ItemStack itemToDamage, int damageAmount) {
        if (itemToDamage.m_41763_()) {
            int currentDamage = itemToDamage.m_41773_();
            int maxDamage = itemToDamage.m_41776_();
            int damageDifference = maxDamage - currentDamage;
            int damageToSet = damageDifference - damageAmount;
            if (damageDifference >= damageAmount && damageToSet > 0) {
                itemToDamage.m_41721_(currentDamage + damageAmount);
            } else {
                itemToDamage.m_41774_(1);
                itemToDamage.m_41721_(0);
            }
        }
    }

    public static void writeItemStackToNBT(ItemStack stackSaveToThis, List<ItemStack> listToStore) {
        CompoundTag compound = new CompoundTag();
        CompoundTag compoundStorage = new CompoundTag();
        if (stackSaveToThis.m_41782_()) {
            compound = stackSaveToThis.m_41783_();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(listToStore.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, listToStore.get(i));
        }
        compoundStorage = handler.serializeNBT();
        compound.m_128365_("mowlibitemStorage", (Tag)compoundStorage);
        stackSaveToThis.m_41751_(compound);
    }

    public static List<ItemStack> readItemStackFromNBT(ItemStack storedOnThisStack) {
        CompoundTag getCompound;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (storedOnThisStack.m_41782_() && (getCompound = storedOnThisStack.m_41783_()).m_128441_("mowlibitemStorage")) {
            CompoundTag invTag = getCompound.m_128469_("mowlibitemStorage");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                stackList.add(handler.getStackInSlot(i));
            }
        }
        return stackList;
    }

    public static void writeListStackToNBT(ItemStack stackSaveToThis, List<ItemStack> listToStore, String path) {
        CompoundTag compound = new CompoundTag();
        CompoundTag compoundStorage = new CompoundTag();
        if (stackSaveToThis.m_41782_()) {
            compound = stackSaveToThis.m_41783_();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(listToStore.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, listToStore.get(i));
        }
        compoundStorage = handler.serializeNBT();
        compound.m_128365_(path, (Tag)compoundStorage);
        stackSaveToThis.m_41751_(compound);
    }

    public static List<ItemStack> readListStackFromNBT(ItemStack storedOnThisStack, String path) {
        CompoundTag getCompound;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (storedOnThisStack.m_41782_() && (getCompound = storedOnThisStack.m_41783_()).m_128441_(path)) {
            CompoundTag invTag = getCompound.m_128469_(path);
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                stackList.add(handler.getStackInSlot(i));
            }
        }
        return stackList;
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler h) {
        for (int i = 0; i < h.getSlots(); ++i) {
            MowLibItemUtils.spawnItemStack(worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), h.getStackInSlot(i));
        }
    }
}

