/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.datagen.provider.client;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import earth.terrarium.chipped.common.registry.ModBlocks;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final ExistingFileHelper exFileHelper;

    public ModBlockStateProvider(DataGenerator output, ExistingFileHelper exFileHelper) {
        super(output, "chipped", exFileHelper);
        this.exFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        this.createSet(ModBlocks.AMETHYST_BLOCK, "amethyst_block");
        this.createSet(ModBlocks.ANCIENT_DEBRIS, "ancient_debris");
        this.createSet(ModBlocks.ANDESITE, "andesite");
        this.createSet(ModBlocks.BASALT, "basalt");
        this.createSet(ModBlocks.BLACKSTONE, "blackstone");
        this.createSet(ModBlocks.BLUE_ICE, "blue_ice");
        this.createSet(ModBlocks.CALCITE, "calcite");
        this.createSet(ModBlocks.COAL_BLOCK, "coal_block");
        this.createSet(ModBlocks.COBBLESTONE, "cobblestone");
        this.createSet(ModBlocks.CRYING_OBSIDIAN, "crying_obsidian");
        this.createSet(ModBlocks.DARK_PRISMARINE, "dark_prismarine");
        this.createSet(ModBlocks.DEEPSLATE, "deepslate");
        this.createSet(ModBlocks.DIORITE, "diorite");
        this.createSet(ModBlocks.DIRT, "dirt");
        this.createSet(ModBlocks.DRIPSTONE_BLOCK, "dripstone_block");
        this.createSet(ModBlocks.END_STONE, "end_stone");
        this.createSet(ModBlocks.GILDED_BLACKSTONE, "gilded_blackstone");
        this.createSet(ModBlocks.GRANITE, "granite");
        this.createSet(ModBlocks.ICE, "ice");
        this.createSet(ModBlocks.LAPIS_BLOCK, "lapis_block");
        this.createSet(ModBlocks.LODESTONE, "lodestone");
        this.createSet(ModBlocks.MAGMA_BLOCK, "magma_block");
        this.createSet(ModBlocks.MOSSY_COBBLESTONE, "mossy_cobblestone");
        this.createSet(ModBlocks.MOSSY_STONE_BRICKS, "mossy_stone_bricks");
        this.createSet(ModBlocks.NETHER_BRICKS, "nether_bricks");
        this.createSet(ModBlocks.NETHERRACK, "netherrack");
        this.createSet(ModBlocks.OBSIDIAN, "obsidian");
        this.createSet(ModBlocks.PACKED_ICE, "packed_ice");
        this.createSet(ModBlocks.PRISMARINE, "prismarine");
        this.createSet(ModBlocks.PURPUR_BLOCK, "purpur_block");
        this.createSet(ModBlocks.QUARTZ_BLOCK, "quartz_block");
        this.createSet(ModBlocks.RAW_COPPER_BLOCK, "raw_copper_block");
        this.createSet(ModBlocks.RAW_GOLD_BLOCK, "raw_gold_block");
        this.createSet(ModBlocks.RAW_IRON_BLOCK, "raw_iron_block");
        this.createSet(ModBlocks.RED_NETHER_BRICKS, "red_nether_bricks");
        this.createSet(ModBlocks.RED_SANDSTONE, "red_sandstone");
        this.createSet(ModBlocks.REDSTONE_BLOCK, "redstone_block");
        this.createSet(ModBlocks.SANDSTONE, "sandstone");
        this.createSet(ModBlocks.STONE, "stone");
        this.createSet(ModBlocks.SMOOTH_STONE, "smooth_stone");
        this.createSet(ModBlocks.SNOW_BLOCK, "snow_block");
        this.createSet(ModBlocks.TUFF, "tuff");
        this.createSet(ModBlocks.CLAY, "clay");
        this.createSet(ModBlocks.TERRACOTTA, "terracotta");
        this.createSet(ModBlocks.BLACK_TERRACOTTA, "black_terracotta");
        this.createSet(ModBlocks.BLUE_TERRACOTTA, "blue_terracotta");
        this.createSet(ModBlocks.BROWN_TERRACOTTA, "brown_terracotta");
        this.createSet(ModBlocks.CYAN_TERRACOTTA, "cyan_terracotta");
        this.createSet(ModBlocks.GRAY_TERRACOTTA, "gray_terracotta");
        this.createSet(ModBlocks.GREEN_TERRACOTTA, "green_terracotta");
        this.createSet(ModBlocks.LIGHT_BLUE_TERRACOTTA, "light_blue_terracotta");
        this.createSet(ModBlocks.LIGHT_GRAY_TERRACOTTA, "light_gray_terracotta");
        this.createSet(ModBlocks.LIME_TERRACOTTA, "lime_terracotta");
        this.createSet(ModBlocks.MAGENTA_TERRACOTTA, "magenta_terracotta");
        this.createSet(ModBlocks.ORANGE_TERRACOTTA, "orange_terracotta");
        this.createSet(ModBlocks.PINK_TERRACOTTA, "pink_terracotta");
        this.createSet(ModBlocks.PURPLE_TERRACOTTA, "purple_terracotta");
        this.createSet(ModBlocks.RED_TERRACOTTA, "red_terracotta");
        this.createSet(ModBlocks.WHITE_TERRACOTTA, "white_terracotta");
        this.createSet(ModBlocks.YELLOW_TERRACOTTA, "yellow_terracotta");
        this.createGlazedTerracotta(ModBlocks.BLACK_GLAZED_TERRACOTTA, "black_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.BLUE_GLAZED_TERRACOTTA, "blue_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.BROWN_GLAZED_TERRACOTTA, "brown_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.CYAN_GLAZED_TERRACOTTA, "cyan_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.GRAY_GLAZED_TERRACOTTA, "gray_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.GREEN_GLAZED_TERRACOTTA, "green_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.LIGHT_BLUE_GLAZED_TERRACOTTA, "light_blue_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.LIGHT_GRAY_GLAZED_TERRACOTTA, "light_gray_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.LIME_GLAZED_TERRACOTTA, "lime_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.MAGENTA_GLAZED_TERRACOTTA, "magenta_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.ORANGE_GLAZED_TERRACOTTA, "orange_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.PINK_GLAZED_TERRACOTTA, "pink_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.PURPLE_GLAZED_TERRACOTTA, "purple_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.RED_GLAZED_TERRACOTTA, "red_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.WHITE_GLAZED_TERRACOTTA, "white_glazed_terracotta");
        this.createGlazedTerracotta(ModBlocks.YELLOW_GLAZED_TERRACOTTA, "yellow_glazed_terracotta");
        this.createSet(ModBlocks.BLACK_CONCRETE, "black_concrete");
        this.createSet(ModBlocks.BLUE_CONCRETE, "blue_concrete");
        this.createSet(ModBlocks.BROWN_CONCRETE, "brown_concrete");
        this.createSet(ModBlocks.CYAN_CONCRETE, "cyan_concrete");
        this.createSet(ModBlocks.GRAY_CONCRETE, "gray_concrete");
        this.createSet(ModBlocks.GREEN_CONCRETE, "green_concrete");
        this.createSet(ModBlocks.LIGHT_BLUE_CONCRETE, "light_blue_concrete");
        this.createSet(ModBlocks.LIGHT_GRAY_CONCRETE, "light_gray_concrete");
        this.createSet(ModBlocks.LIME_CONCRETE, "lime_concrete");
        this.createSet(ModBlocks.MAGENTA_CONCRETE, "magenta_concrete");
        this.createSet(ModBlocks.ORANGE_CONCRETE, "orange_concrete");
        this.createSet(ModBlocks.PINK_CONCRETE, "pink_concrete");
        this.createSet(ModBlocks.PURPLE_CONCRETE, "purple_concrete");
        this.createSet(ModBlocks.RED_CONCRETE, "red_concrete");
        this.createSet(ModBlocks.WHITE_CONCRETE, "white_concrete");
        this.createSet(ModBlocks.YELLOW_CONCRETE, "yellow_concrete");
        this.createSet(ModBlocks.BLACK_WOOL, "black_wool");
        this.createSet(ModBlocks.BLUE_WOOL, "blue_wool");
        this.createSet(ModBlocks.BROWN_WOOL, "brown_wool");
        this.createSet(ModBlocks.CYAN_WOOL, "cyan_wool");
        this.createSet(ModBlocks.GRAY_WOOL, "gray_wool");
        this.createSet(ModBlocks.GREEN_WOOL, "green_wool");
        this.createSet(ModBlocks.LIGHT_BLUE_WOOL, "light_blue_wool");
        this.createSet(ModBlocks.LIGHT_GRAY_WOOL, "light_gray_wool");
        this.createSet(ModBlocks.LIME_WOOL, "lime_wool");
        this.createSet(ModBlocks.MAGENTA_WOOL, "magenta_wool");
        this.createSet(ModBlocks.ORANGE_WOOL, "orange_wool");
        this.createSet(ModBlocks.PINK_WOOL, "pink_wool");
        this.createSet(ModBlocks.PURPLE_WOOL, "purple_wool");
        this.createSet(ModBlocks.RED_WOOL, "red_wool");
        this.createSet(ModBlocks.WHITE_WOOL, "white_wool");
        this.createSet(ModBlocks.YELLOW_WOOL, "yellow_wool");
        this.createCarpetSet(ModBlocks.BLACK_CARPET, "black_wool");
        this.createCarpetSet(ModBlocks.BLUE_CARPET, "blue_wool");
        this.createCarpetSet(ModBlocks.BROWN_CARPET, "brown_wool");
        this.createCarpetSet(ModBlocks.CYAN_CARPET, "cyan_wool");
        this.createCarpetSet(ModBlocks.GRAY_CARPET, "gray_wool");
        this.createCarpetSet(ModBlocks.GREEN_CARPET, "green_wool");
        this.createCarpetSet(ModBlocks.LIGHT_BLUE_CARPET, "light_blue_wool");
        this.createCarpetSet(ModBlocks.LIGHT_GRAY_CARPET, "light_gray_wool");
        this.createCarpetSet(ModBlocks.LIME_CARPET, "lime_wool");
        this.createCarpetSet(ModBlocks.MAGENTA_CARPET, "magenta_wool");
        this.createCarpetSet(ModBlocks.ORANGE_CARPET, "orange_wool");
        this.createCarpetSet(ModBlocks.PINK_CARPET, "pink_wool");
        this.createCarpetSet(ModBlocks.PURPLE_CARPET, "purple_wool");
        this.createCarpetSet(ModBlocks.RED_CARPET, "red_wool");
        this.createCarpetSet(ModBlocks.WHITE_CARPET, "white_wool");
        this.createCarpetSet(ModBlocks.YELLOW_CARPET, "yellow_wool");
        this.createSet(ModBlocks.ACACIA_PLANKS, "acacia_planks");
        this.createSet(ModBlocks.BIRCH_PLANKS, "birch_planks");
        this.createSet(ModBlocks.DARK_OAK_PLANKS, "dark_oak_planks");
        this.createSet(ModBlocks.JUNGLE_PLANKS, "jungle_planks");
        this.createSet(ModBlocks.MANGROVE_PLANKS, "mangrove_planks");
        this.createSet(ModBlocks.OAK_PLANKS, "oak_planks");
        this.createSet(ModBlocks.SPRUCE_PLANKS, "spruce_planks");
        this.createSet(ModBlocks.CRIMSON_PLANKS, "crimson_planks");
        this.createSet(ModBlocks.WARPED_PLANKS, "warped_planks");
        this.createSet(ModBlocks.BRICKS, "bricks");
        this.createSet(ModBlocks.MUD, "mud");
        this.createSet(ModBlocks.PACKED_MUD, "packed_mud");
        this.createSet(ModBlocks.MUD_BRICKS, "mud_bricks");
        this.createLogSet(ModBlocks.ACACIA_LOG, "acacia_log");
        this.createLogSet(ModBlocks.BIRCH_LOG, "birch_log");
        this.createLogSet(ModBlocks.DARK_OAK_LOG, "dark_oak_log");
        this.createLogSet(ModBlocks.JUNGLE_LOG, "jungle_log");
        this.createLogSet(ModBlocks.MANGROVE_LOG, "mangrove_log");
        this.createLogSet(ModBlocks.OAK_LOG, "oak_log");
        this.createLogSet(ModBlocks.SPRUCE_LOG, "spruce_log");
        this.createLogSet(ModBlocks.CRIMSON_STEM, "crimson_stem");
        this.createLogSet(ModBlocks.WARPED_STEM, "warped_stem");
        this.createSet(ModBlocks.GLASS, "glass");
        this.createGlassPaneSet(ModBlocks.GLASS_PANE, "glass_pane");
        this.createSet(ModBlocks.BLACK_STAINED_GLASS, "black_stained_glass");
        this.createGlassPaneSet(ModBlocks.BLACK_STAINED_GLASS_PANE, "black_stained_glass_pane");
        this.createSet(ModBlocks.BLUE_STAINED_GLASS, "blue_stained_glass");
        this.createGlassPaneSet(ModBlocks.BLUE_STAINED_GLASS_PANE, "blue_stained_glass_pane");
        this.createSet(ModBlocks.BROWN_STAINED_GLASS, "brown_stained_glass");
        this.createGlassPaneSet(ModBlocks.BROWN_STAINED_GLASS_PANE, "brown_stained_glass_pane");
        this.createSet(ModBlocks.CYAN_STAINED_GLASS, "cyan_stained_glass");
        this.createGlassPaneSet(ModBlocks.CYAN_STAINED_GLASS_PANE, "cyan_stained_glass_pane");
        this.createSet(ModBlocks.GRAY_STAINED_GLASS, "gray_stained_glass");
        this.createGlassPaneSet(ModBlocks.GRAY_STAINED_GLASS_PANE, "gray_stained_glass_pane");
        this.createSet(ModBlocks.GREEN_STAINED_GLASS, "green_stained_glass");
        this.createGlassPaneSet(ModBlocks.GREEN_STAINED_GLASS_PANE, "green_stained_glass_pane");
        this.createSet(ModBlocks.LIGHT_BLUE_STAINED_GLASS, "light_blue_stained_glass");
        this.createGlassPaneSet(ModBlocks.LIGHT_BLUE_STAINED_GLASS_PANE, "light_blue_stained_glass_pane");
        this.createSet(ModBlocks.LIGHT_GRAY_STAINED_GLASS, "light_gray_stained_glass");
        this.createGlassPaneSet(ModBlocks.LIGHT_GRAY_STAINED_GLASS_PANE, "light_gray_stained_glass_pane");
        this.createSet(ModBlocks.LIME_STAINED_GLASS, "lime_stained_glass");
        this.createGlassPaneSet(ModBlocks.LIME_STAINED_GLASS_PANE, "lime_stained_glass_pane");
        this.createSet(ModBlocks.MAGENTA_STAINED_GLASS, "magenta_stained_glass");
        this.createGlassPaneSet(ModBlocks.MAGENTA_STAINED_GLASS_PANE, "magenta_stained_glass_pane");
        this.createSet(ModBlocks.ORANGE_STAINED_GLASS, "orange_stained_glass");
        this.createGlassPaneSet(ModBlocks.ORANGE_STAINED_GLASS_PANE, "orange_stained_glass_pane");
        this.createSet(ModBlocks.PINK_STAINED_GLASS, "pink_stained_glass");
        this.createGlassPaneSet(ModBlocks.PINK_STAINED_GLASS_PANE, "pink_stained_glass_pane");
        this.createSet(ModBlocks.PURPLE_STAINED_GLASS, "purple_stained_glass");
        this.createGlassPaneSet(ModBlocks.PURPLE_STAINED_GLASS_PANE, "purple_stained_glass_pane");
        this.createSet(ModBlocks.RED_STAINED_GLASS, "red_stained_glass");
        this.createGlassPaneSet(ModBlocks.RED_STAINED_GLASS_PANE, "red_stained_glass_pane");
        this.createSet(ModBlocks.WHITE_STAINED_GLASS, "white_stained_glass");
        this.createGlassPaneSet(ModBlocks.WHITE_STAINED_GLASS_PANE, "white_stained_glass_pane");
        this.createSet(ModBlocks.YELLOW_STAINED_GLASS, "yellow_stained_glass");
        this.createGlassPaneSet(ModBlocks.YELLOW_STAINED_GLASS_PANE, "yellow_stained_glass_pane");
        this.createSet(ModBlocks.ACACIA_LEAVES, "acacia_leaves", 4);
        this.createSet(ModBlocks.BIRCH_LEAVES, "birch_leaves", 4);
        this.createSet(ModBlocks.DARK_OAK_LEAVES, "dark_oak_leaves", 4);
        this.createSet(ModBlocks.JUNGLE_LEAVES, "jungle_leaves", 4);
        this.createRootSet(ModBlocks.MANGROVE_ROOTS, "mangrove_roots");
        this.createSet(ModBlocks.OAK_LEAVES, "oak_leaves", 4);
        this.createSet(ModBlocks.SPRUCE_LEAVES, "spruce_leaves", 4);
        this.createSet(ModBlocks.OCHRE_FROGLIGHT, "ochre_froglight");
        this.createSet(ModBlocks.PEARLESCENT_FROGLIGHT, "pearlescent_froglight");
        this.createSet(ModBlocks.VERDANT_FROGLIGHT, "verdant_froglight");
        this.createSnowyLeaves((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("chipped", "frosted_acacia_leaves")), "acacia_leaves");
        this.createSnowyLeaves((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("chipped", "frosted_birch_leaves")), "birch_leaves");
        this.createSnowyLeaves((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("chipped", "frosted_dark_oak_leaves")), "dark_oak_leaves");
        this.createSnowyLeaves((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("chipped", "frosted_jungle_leaves")), "jungle_leaves");
        this.createSnowyLeaves((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("chipped", "frosted_oak_leaves")), "oak_leaves");
        this.createSnowyLeaves((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("chipped", "frosted_spruce_leaves")), "spruce_leaves");
        this.createSet(ModBlocks.DIAMOND_BLOCK, "diamond_block");
        this.createSet(ModBlocks.EMERALD_BLOCK, "emerald_block");
        this.createSet(ModBlocks.GOLD_BLOCK, "gold_block");
        this.createSet(ModBlocks.IRON_BLOCK, "iron_block");
        this.createSet(ModBlocks.NETHERITE_BLOCK, "netherite_block");
        this.createBarrelSet(ModBlocks.BARREL, "barrel");
        this.createLogSet(ModBlocks.BONE_BLOCK, "bone_block");
        this.createBookshelfSet(ModBlocks.BOOKSHELF, "bookshelf");
        this.createSet(ModBlocks.BROWN_MUSHROOM_BLOCK, "brown_mushroom_block");
        this.createSet(ModBlocks.RED_MUSHROOM_BLOCK, "red_mushroom_block");
        this.createCross(ModBlocks.BROWN_MUSHROOM, "brown_mushroom");
        this.createCross(ModBlocks.RED_MUSHROOM, "red_mushroom");
        this.createCross(ModBlocks.COBWEB, "cobweb");
        this.createSet(ModBlocks.SPONGE, "sponge");
        this.createSet(ModBlocks.MUSHROOM_STEM, "mushroom_stem");
        this.createSet(ModBlocks.GLOWSTONE, "glowstone");
        this.createSet(ModBlocks.GRAVEL, "gravel");
        this.createLogSet(ModBlocks.HAY_BLOCK, "hay_block");
        this.createIronBarsSet(ModBlocks.IRON_BARS, "iron_bars");
        this.createSet(ModBlocks.MOSS_BLOCK, "moss_block");
        this.createLadderSet(ModBlocks.LADDER, "ladder");
        this.createMelonBlock(ModBlocks.MELON, "melon");
        this.createSet(ModBlocks.SHROOMLIGHT, "shroomlight");
        this.createSet(ModBlocks.SEA_LANTERN, "sea_lantern");
        this.createSet(ModBlocks.SAND, "sand");
        this.createSet(ModBlocks.SOUL_SAND, "soul_sand");
        this.createRedstoneLampBlock(ModBlocks.REDSTONE_LAMP, "redstone_lamp");
        this.createSet(ModBlocks.WAXED_COPPER_BLOCK, "waxed_copper_block");
        this.createSet(ModBlocks.WAXED_EXPOSED_COPPER, "waxed_exposed_copper");
        this.createSet(ModBlocks.WAXED_WEATHERED_COPPER, "waxed_weathered_copper");
        this.createSet(ModBlocks.WAXED_OXIDIZED_COPPER, "waxed_oxidized_copper");
        this.createStrippedLogSet(ModBlocks.STRIPPED_ACACIA_LOG, "stripped_acacia_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_BIRCH_LOG, "stripped_birch_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_DARK_OAK_LOG, "stripped_dark_oak_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_JUNGLE_LOG, "stripped_jungle_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_MANGROVE_LOG, "stripped_mangrove_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_OAK_LOG, "stripped_oak_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_SPRUCE_LOG, "stripped_spruce_log");
        this.createStrippedLogSet(ModBlocks.STRIPPED_WARPED_STEM, "stripped_warped_stem");
        this.createStrippedLogSet(ModBlocks.STRIPPED_CRIMSON_STEM, "stripped_crimson_stem");
        this.createDoorSet(ModBlocks.ACACIA_DOOR, "acacia_door");
        this.createDoorSet(ModBlocks.BIRCH_DOOR, "birch_door");
        this.createDoorSet(ModBlocks.DARK_OAK_DOOR, "dark_oak_door");
        this.createDoorSet(ModBlocks.JUNGLE_DOOR, "jungle_door");
        this.createDoorSet(ModBlocks.MANGROVE_DOOR, "mangrove_door");
        this.createDoorSet(ModBlocks.OAK_DOOR, "oak_door");
        this.createDoorSet(ModBlocks.SPRUCE_DOOR, "spruce_door");
        this.createDoorSet(ModBlocks.CRIMSON_DOOR, "crimson_door");
        this.createDoorSet(ModBlocks.WARPED_DOOR, "warped_door");
        this.createTrapdoorSet(ModBlocks.ACACIA_TRAPDOOR, "acacia_trapdoor");
        this.createTrapdoorSet(ModBlocks.BIRCH_TRAPDOOR, "birch_trapdoor");
        this.createTrapdoorSet(ModBlocks.DARK_OAK_TRAPDOOR, "dark_oak_trapdoor");
        this.createTrapdoorSet(ModBlocks.JUNGLE_TRAPDOOR, "jungle_trapdoor");
        this.createTrapdoorSet(ModBlocks.MANGROVE_TRAPDOOR, "mangrove_trapdoor");
        this.createTrapdoorSet(ModBlocks.OAK_TRAPDOOR, "oak_trapdoor");
        this.createTrapdoorSet(ModBlocks.SPRUCE_TRAPDOOR, "spruce_trapdoor");
        this.createTrapdoorSet(ModBlocks.CRIMSON_TRAPDOOR, "crimson_trapdoor");
        this.createTrapdoorSet(ModBlocks.WARPED_TRAPDOOR, "warped_trapdoor");
        this.createCross(ModBlocks.CRIMSON_ROOTS, "crimson_roots");
        this.createCross(ModBlocks.WARPED_ROOTS, "warped_roots");
        this.createDriedKelpSet(ModBlocks.DRIED_KELP_BLOCK, "dried_kelp_block");
        this.createLilyPadSet(ModBlocks.LILY_PAD, "lily_pad");
        this.createCross(ModBlocks.NETHER_SPROUTS, "nether_sprouts");
        this.createSet(ModBlocks.NETHER_WART_BLOCK, "nether_wart_block");
        this.createPumpkinSet(ModBlocks.PUMPKIN, "pumpkin");
        this.createCarvedPumpkinBlock(ModBlocks.CARVED_PUMPKIN, "carved_pumpkin");
        this.createCarvedPumpkinBlock(ModBlocks.JACK_O_LANTERN, "jack_o_lantern");
        this.createSet(ModBlocks.WARPED_WART_BLOCK, "warped_wart_block");
        this.createCross(ModBlocks.CRIMSON_FUNGUS, "crimson_fungus");
        this.createCross(ModBlocks.WARPED_FUNGUS, "warped_fungus");
        this.createTorchSet(ModBlocks.TORCH, "torch");
        this.createRedstoneTorchSet(ModBlocks.REDSTONE_TORCH, "redstone_torch");
        this.createPointedDripstoneSet(ModBlocks.POINTED_DRIPSTONE, "pointed_dripstone");
        this.createLanternSet(ModBlocks.LANTERN);
        this.createLanternSet(ModBlocks.SOUL_LANTERN);
    }

    private void createPointedDripstoneSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> {
            ResourceLocation texture = this.customTexture((Block)block, folder);
            BlockModelBuilder downBase = this.createChildModel(this.extend(texture, "_down_base"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_down_base"), "cross");
            BlockModelBuilder downFrustum = this.createChildModel(this.extend(texture, "_down_frustum"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_down_frustum"), "cross");
            BlockModelBuilder downMiddle = this.createChildModel(this.extend(texture, "_down_middle"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_down_middle"), "cross");
            BlockModelBuilder downTipMerge = this.createChildModel(this.extend(texture, "_down_tip_merge"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_down_tip_merge"), "cross");
            BlockModelBuilder downTip = this.createChildModel(this.extend(texture, "_down_tip"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_down_tip"), "cross");
            BlockModelBuilder upBase = this.createChildModel(this.extend(texture, "_up_base"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_up_base"), "cross");
            BlockModelBuilder upFrustum = this.createChildModel(this.extend(texture, "_up_frustum"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_up_frustum"), "cross");
            BlockModelBuilder upMiddle = this.createChildModel(this.extend(texture, "_up_middle"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_up_middle"), "cross");
            BlockModelBuilder upTipMerge = this.createChildModel(this.extend(texture, "_up_tip_merge"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_up_tip_merge"), "cross");
            BlockModelBuilder upTip = this.createChildModel(this.extend(texture, "_up_tip"), new ResourceLocation("block/pointed_dripstone"), this.extend(texture, "_up_tip"), "cross");
            this.getVariantBuilder((Block)block).forAllStates(state -> {
                DripstoneThickness thickness = (DripstoneThickness)state.m_61143_((Property)PointedDripstoneBlock.f_154010_);
                Direction dir = (Direction)state.m_61143_((Property)PointedDripstoneBlock.f_154009_);
                ConfiguredModel.Builder builder = ConfiguredModel.builder();
                return builder.modelFile((ModelFile)(switch (thickness) {
                    default -> throw new IncompatibleClassChangeError();
                    case DripstoneThickness.TIP_MERGE -> {
                        if (dir == Direction.DOWN) {
                            yield downTipMerge;
                        }
                        yield upTipMerge;
                    }
                    case DripstoneThickness.TIP -> {
                        if (dir == Direction.DOWN) {
                            yield downTip;
                        }
                        yield upTip;
                    }
                    case DripstoneThickness.FRUSTUM -> {
                        if (dir == Direction.DOWN) {
                            yield downFrustum;
                        }
                        yield upFrustum;
                    }
                    case DripstoneThickness.MIDDLE -> {
                        if (dir == Direction.DOWN) {
                            yield downMiddle;
                        }
                        yield upMiddle;
                    }
                    case DripstoneThickness.BASE -> dir == Direction.DOWN ? downBase : upBase;
                })).build();
            });
        });
    }

    private void createSnowyLeaves(Block block, String folder) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(this.name(block), this.customTexture(block, folder), this.extend(this.customTexture(block, folder), "_top"));
        this.simpleBlock(block, (ModelFile)model);
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void createSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, folder, -1);
    }

    private void createSet(ResourcefulRegistry<Block> registry, String folder, int exclude) {
        this.createSet(registry, exclude, (block, i) -> this.simpleBlock((Block)block, (ModelFile)this.models().cubeAll(this.name((Block)block), this.customTexture((Block)block, folder))));
    }

    private void createCross(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> this.simpleBlock((Block)block, (ModelFile)this.models().cross(this.name((Block)block), this.customTexture((Block)block, folder))));
    }

    private void createCarpetSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> this.simpleBlock((Block)block, (ModelFile)this.models().carpet(this.name((Block)block), new ResourceLocation("chipped", this.customTexture((Block)block, folder).m_135815_().replace("_carpet", "_wool")))));
    }

    private void createDriedKelpSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            ResourceLocation texture = this.customTexture((Block)block, folder);
            this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("particle", texture)).texture("down", this.extend(texture, "_top"))).texture("up", this.extend(texture, "_top"))).texture("north", texture)).texture("east", texture)).texture("south", texture)).texture("west", texture)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/dried_kelp_block"))));
        });
    }

    private void createLilyPadSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> {
            ResourceLocation texture = this.customTexture((Block)block, folder);
            this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("particle", texture)).texture("texture", texture)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/lily_pad"))));
        });
    }

    private void createPumpkinSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            ResourceLocation texture = this.customTexture((Block)block, folder);
            this.simpleBlock((Block)block, (ModelFile)this.models().cubeBottomTop(this.name((Block)block), this.extend(texture, "_side"), this.extend(texture, "_bottom"), this.extend(texture, "_top")));
        });
    }

    private void createCarvedPumpkinBlock(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            ResourceLocation texture = this.customTexture((Block)block, folder);
            if (texture.m_135815_().contains("nether")) {
                this.createCarvedPumpkinBlock((Block)block, folder, new ResourceLocation("chipped", "block/pumpkin/nether_pumpkin_top"), new ResourceLocation("chipped", "block/pumpkin/nether_pumpkin_bottom"), new ResourceLocation("chipped", "block/pumpkin/nether_pumpkin_side"));
            } else if (texture.m_135815_().contains("end_purple")) {
                this.createCarvedPumpkinBlock((Block)block, folder, new ResourceLocation("chipped", "block/pumpkin/end_pumpkin_purple_top"), new ResourceLocation("chipped", "block/pumpkin/end_pumpkin_purple_bottom"), new ResourceLocation("chipped", "block/pumpkin/end_pumpkin_purple_side"));
            } else if (texture.m_135815_().contains("end")) {
                this.createCarvedPumpkinBlock((Block)block, folder, new ResourceLocation("chipped", "block/pumpkin/end_pumpkin_top"), new ResourceLocation("chipped", "block/pumpkin/end_pumpkin_bottom"), new ResourceLocation("chipped", "block/pumpkin/end_pumpkin_side"));
            } else {
                this.createCarvedPumpkinBlock((Block)block, folder, new ResourceLocation("block/pumpkin_top"), new ResourceLocation("block/pumpkin_top"), new ResourceLocation("block/pumpkin_side"));
            }
        });
    }

    private void createCarvedPumpkinBlock(Block block, String folder, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        ResourceLocation texture = this.customTexture(block, folder);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("down", bottom)).texture("east", texture)).texture("north", side)).texture("particle", texture)).texture("south", side)).texture("up", top)).texture("west", side)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/cube")));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)CarvedPumpkinBlock.f_51367_);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 90) % 360).build();
        });
    }

    private void createLanternSet(ResourcefulRegistry<Block> registry) {
        this.createSet(registry, -1, false, (block, i) -> this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)LanternBlock.f_153459_) != false ? new ModelFile.UncheckedModelFile(this.extend(this.blockTexture((Block)block), "_hanging")) : new ModelFile.UncheckedModelFile(this.blockTexture((Block)block)))).build()));
    }

    private void createTorchSet(Pair<ResourcefulRegistry<Block>, ResourcefulRegistry<Block>> registry, String folder) {
        this.createSet((ResourcefulRegistry<Block>)((ResourcefulRegistry)registry.getFirst()), -1, false, (block, i) -> {
            ResourceLocation texture = this.customTexture((Block)block, folder);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("torch", texture)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/template_torch")));
            this.simpleBlock((Block)block, (ModelFile)model);
        });
        this.createSet((ResourcefulRegistry<Block>)((ResourcefulRegistry)registry.getSecond()), (Block block, Integer i) -> {
            ResourceLocation texture = new ResourceLocation("chipped", this.customTexture((Block)block, folder).m_135815_().replace("_wall", ""));
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("torch", texture)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/template_torch_wall")));
            this.getVariantBuilder((Block)block).forAllStates(state -> {
                Direction dir = (Direction)state.m_61143_((Property)WallTorchBlock.f_58119_);
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 90) % 360).build();
            });
        });
    }

    private void createRedstoneTorchSet(Pair<ResourcefulRegistry<Block>, ResourcefulRegistry<Block>> registry, String folder) {
        this.createSet((ResourcefulRegistry<Block>)((ResourcefulRegistry)registry.getFirst()), -1, false, (block, i) -> {
            ResourceLocation texture1 = this.customTexture((Block)block, folder);
            BlockModelBuilder model1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("torch", texture1)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/template_torch")));
            ResourceLocation texture2 = this.customTexture((Block)block, folder);
            BlockModelBuilder model2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("torch", texture2)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/template_torch")));
            this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)RedstoneTorchBlock.f_55674_) != false ? model1 : model2)).build());
        });
        this.createSet((ResourcefulRegistry<Block>)((ResourcefulRegistry)registry.getSecond()), (Block block, Integer i) -> {
            ResourceLocation texture = new ResourceLocation("chipped", this.customTexture((Block)block, folder).m_135815_().replace("_wall", ""));
            BlockModelBuilder model1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("torch", this.extend(texture, "_on"))).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/template_torch_wall")));
            BlockModelBuilder model2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("torch", texture)).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/template_torch_wall")));
            this.getVariantBuilder((Block)block).forAllStates(state -> {
                Direction dir = (Direction)state.m_61143_((Property)RedstoneWallTorchBlock.f_55740_);
                return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)RedstoneWallTorchBlock.f_55741_) != false ? model1 : model2)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 90) % 360).build();
            });
        });
    }

    private void createLadderSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> {
            BlockModelBuilder model = this.createChildModel((Block)block, new ResourceLocation("block/ladder"), this.customTexture((Block)block, folder), "texture", folder);
            this.getVariantBuilder((Block)block).forAllStates(state -> {
                Direction dir = (Direction)state.m_61143_((Property)LadderBlock.f_54337_);
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
            });
        });
    }

    private void createGlazedTerracotta(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            BlockModelBuilder model = this.createChildModel((Block)block, new ResourceLocation("block/template_glazed_terracotta"), this.customTexture((Block)block, folder), "pattern", folder);
            this.horizontalBlock((Block)block, (ModelFile)model);
        });
    }

    private void createRootSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("side", this.customTexture((Block)block, folder))).texture("top", this.extend(this.customTexture((Block)block, folder), "_top"))).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/mangrove_roots")));
            this.simpleBlock((Block)block, (ModelFile)model);
        });
    }

    private void createMelonBlock(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            ResourceLocation baseName = this.customTexture((Block)block, folder);
            this.simpleBlock((Block)block, (ModelFile)this.models().cubeBottomTop(this.name((Block)block), baseName, this.extend(baseName, "_bottom"), this.extend(baseName, "_top")));
        });
    }

    private void createBookshelfSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(this.name((Block)block), this.customTexture((Block)block, folder), this.blockTexture(Blocks.f_50705_));
            this.simpleBlock((Block)block, (ModelFile)model);
        });
    }

    private void createBarrelSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            boolean isCrate = this.blockTexture((Block)block).m_135815_().contains("crate");
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block))).texture("bottom", this.extend(this.customTexture((Block)block, folder), isCrate ? "_top" : "_bottom"))).texture("side", this.extend(this.customTexture((Block)block, folder), "_side"))).texture("top", this.extend(this.customTexture((Block)block, folder), "_top"))).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/cube_bottom_top")));
            ModelBuilder openModel = isCrate ? model : ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name((Block)block) + "_open")).texture("bottom", this.extend(this.customTexture((Block)block, folder), "_bottom"))).texture("side", this.extend(this.customTexture((Block)block, folder), "_side"))).texture("top", this.extend(this.customTexture((Block)block, folder), "_top_open"))).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("block/cube_bottom_top")));
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$createBarrelSet$25((ModelFile)openModel, (ModelFile)model, arg_0));
        });
    }

    private void createRedstoneLampBlock(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            ModelBuilder model = this.models().cubeAll(this.name((Block)block), this.customTexture((Block)block, folder));
            ModelBuilder modelOn = this.models().cubeAll(this.name((Block)block) + "_on", this.extend(this.customTexture((Block)block, folder), "_on"));
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$createRedstoneLampBlock$27((ModelFile)modelOn, (ModelFile)model, arg_0));
        });
    }

    private void createLogSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> {
            ResourceLocation baseName = this.customTexture((Block)block, folder);
            this.axisBlock((RotatedPillarBlock)block, baseName, this.extend(baseName, "_top"));
        });
    }

    private void createStrippedLogSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, (Block block, Integer i) -> this.axisBlock((RotatedPillarBlock)block, this.customTexture((Block)block, folder), this.extend(this.customTexture((Block)block, folder), "_top")));
    }

    private void createGlassPaneSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> {
            ResourceLocation paneTopTexture = this.exFileHelper.exists(this.customTexture((Block)block, folder), PackType.CLIENT_RESOURCES, ".png", "textures/block") ? this.extend(this.customTexture((Block)block, folder), "_top") : this.extend(this.blockTexture(Blocks.f_50185_), "_top");
            this.paneBlock((IronBarsBlock)block, this.key((Block)block).m_135815_().replace("_pane", ""), new ResourceLocation("chipped", this.customTexture((Block)block, folder).m_135815_().replace("_pane", "")), paneTopTexture);
        });
    }

    private void createIronBarsSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> this.paneBlock((IronBarsBlock)block, this.key((Block)block).toString(), this.customTexture((Block)block, folder), this.customTexture((Block)block, folder)));
    }

    private void createDoorSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> this.doorBlock((DoorBlock)block, this.extend(this.customTexture((Block)block, folder), "_bottom"), this.extend(this.customTexture((Block)block, folder), "_top")));
    }

    private void createTrapdoorSet(ResourcefulRegistry<Block> registry, String folder) {
        this.createSet(registry, -1, false, (block, i) -> {
            this.trapdoorBlock((TrapDoorBlock)block, this.customTexture((Block)block, folder), false);
            this.simpleBlockItem((Block)block, (ModelFile)new ModelFile.UncheckedModelFile(this.extend(this.blockTexture((Block)block), "_bottom")));
        });
    }

    private void createSet(ResourcefulRegistry<Block> registry, BiConsumer<Block, Integer> consumer) {
        this.createSet(registry, -1, consumer);
    }

    private void createSet(ResourcefulRegistry<Block> registry, int exclude, BiConsumer<Block, Integer> consumer) {
        this.createSet(registry, exclude, true, consumer);
    }

    private void createSet(ResourcefulRegistry<Block> registry, int exclude, boolean makeItem, BiConsumer<Block, Integer> consumer) {
        List<Block> blocks = registry.stream().map(RegistryEntry::get).toList();
        for (int i = 0; i < blocks.size(); ++i) {
            if (i + 1 == exclude) continue;
            Block block = blocks.get(i);
            consumer.accept(block, i + 1);
            if (!makeItem) continue;
            this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile(this.blockTexture(block)));
        }
    }

    public ResourceLocation customTexture(Block block, String folder) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/" + folder + "/" + name.m_135815_());
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private BlockModelBuilder createChildModel(Block block, ResourceLocation parent, ResourceLocation texture, String textureName, String folder) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture(textureName, texture)).texture("particle", this.customTexture(block, folder))).parent((ModelFile)this.models().getExistingFile(parent));
    }

    private BlockModelBuilder createChildModel(ResourceLocation model, ResourceLocation parent, ResourceLocation texture, String textureName) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(model.m_135815_())).texture(textureName, texture)).texture("particle", texture)).parent((ModelFile)this.models().getExistingFile(parent));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$createRedstoneLampBlock$27(ModelFile modelOn, ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)RedstoneLampBlock.f_55654_) != false ? modelOn : model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$createBarrelSet$25(ModelFile openModel, ModelFile model, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BarrelBlock.f_49042_);
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)BarrelBlock.f_49043_) != false ? openModel : model).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
    }
}

