/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;

public class MyTradeEffect {
    public String effectKey;
    public Integer duration;
    public Integer level;
    public Boolean isVisible;

    public MyTradeEffect() {
        if (this.duration == null) {
            this.duration = 300;
        }
        if (this.level == null) {
            this.level = 1;
        }
        if (this.isVisible == null) {
            this.isVisible = true;
        }
    }

    public Potion getPotionKey(String key) {
        return TradeUtil.getPotionFromKey(key);
    }

    public MobEffect getEffect(String key) {
        return TradeUtil.getEffectFromKey(key);
    }

    public MobEffectInstance getInstance() {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new MobEffectInstance(this.getEffect(this.effectKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }

    public MobEffectInstance getInstance(String chosenKey) {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new MobEffectInstance(this.getEffect(chosenKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }

    public boolean validate(String profession, int tradeEntry, String itemKey) {
        boolean isValid = true;
        if (this.effectKey == null || this.effectKey == "") {
            ModLogger.warn("Unable to add a custom trade! Reason: the effect key has not been defined - profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
            isValid = false;
        } else if (!TradeUtil.checkEffectKey(this.effectKey)) {
            ModLogger.warn("Unable to add a custom trade! Reason: effect invalid - " + this.effectKey + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
            isValid = false;
        }
        return isValid;
    }
}

