/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.annotation.meta.RemoveIn;

@Deprecated(forRemoval=true)
@RemoveIn(minecraft="1.19.3")
public class PotionIngredient
extends Ingredient {
    @Nullable
    public final Item potionItem;
    public final Potion potion;

    public PotionIngredient(@Nullable Item potionItem, Potion potion) {
        super(Stream.empty());
        this.potionItem = potionItem;
        this.potion = potion;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        ItemStack stack = new ItemStack((ItemLike)(this.potionItem == null ? Items.f_42589_ : this.potionItem));
        PotionUtils.m_43549_((ItemStack)stack, (Potion)this.potion);
        return new ItemStack[]{stack};
    }

    public boolean test(@Nullable ItemStack stack) {
        if (!(stack == null || stack.m_41619_() || this.potionItem != null && stack.m_41720_() != this.potionItem)) {
            Potion itemPotion = PotionUtils.m_43579_((ItemStack)stack);
            return itemPotion == this.potion;
        }
        return false;
    }

    @Nonnull
    public IntList m_43931_() {
        ItemStack[] stacks = this.m_43908_();
        IntArrayList ial = new IntArrayList(stacks.length);
        for (ItemStack stack : stacks) {
            ial.add(StackedContents.m_36496_((ItemStack)stack));
        }
        return ial;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean m_43947_() {
        return this.potionItem == Items.f_41852_;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        if (this.potionItem == null) {
            json.add("item", (JsonElement)JsonNull.INSTANCE);
        } else {
            json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.potionItem)).toString());
        }
        json.addProperty("potion", Objects.requireNonNull(ForgeRegistries.POTIONS.getKey((Object)this.potion)).toString());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PotionIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public PotionIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            Potion potion;
            Item potionItem;
            if (buffer.readBoolean()) {
                potionItem = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
                if (potionItem == null) {
                    potionItem = Items.f_41852_;
                }
            } else {
                potionItem = null;
            }
            if ((potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(buffer.m_130277_()))) == null) {
                potion = Potions.f_43598_;
            }
            return new PotionIngredient(potionItem, potion);
        }

        @Nonnull
        public PotionIngredient parse(JsonObject json) {
            Item potionItem;
            JsonElement itemJson = json.get("item");
            if (itemJson.isJsonNull()) {
                potionItem = null;
            } else {
                ResourceLocation potionRl = ResourceLocation.m_135820_((String)itemJson.getAsString());
                Item item = potionItem = potionRl == null ? null : (Item)ForgeRegistries.ITEMS.getValue(potionRl);
                if (potionItem == null) {
                    potionItem = Items.f_41852_;
                }
            }
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(json.get("potion").getAsString()));
            if (potion == null) {
                potion = Potions.f_43598_;
            }
            return new PotionIngredient(potionItem, potion);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull PotionIngredient ingredient) {
            buffer.writeBoolean(ingredient.potionItem != null);
            if (ingredient.potionItem != null) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.potionItem)));
            }
            buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.POTIONS.getKey((Object)ingredient.potion)));
        }
    }
}

