/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.registration.tracking;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.impl.reflect.ReflectionHacks;
import org.moddingx.libx.impl.registration.tracking.TrackingInstance;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.mod.ModXRegistration;
import org.moddingx.libx.registration.MultiRegisterable;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public final class TrackingData<T> {
    public final ResourceLocation registryId;
    public final IForgeRegistry<T> registry;
    private final List<TrackedStaticField> staticFields;
    private final List<TrackedInstanceField> instanceFields;
    private final List<TrackedInstanceAction<T>> actions;
    private final Set<TrackedFieldKey> trackedFields;

    public TrackingData(IForgeRegistry<T> registry) {
        this.registryId = registry.getRegistryName();
        this.registry = registry;
        this.staticFields = new ArrayList<TrackedStaticField>();
        this.instanceFields = new ArrayList<TrackedInstanceField>();
        this.actions = new ArrayList<TrackedInstanceAction<T>>();
        this.trackedFields = new HashSet<TrackedFieldKey>();
    }

    public synchronized void addStatic(ResourceLocation id, Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalStateException("Can't track registry element field: Must be static: " + field);
        }
        TrackedFieldKey key = TrackedFieldKey.create(field, null);
        if (!this.trackedFields.contains(key)) {
            this.staticFields.add(new TrackedStaticField(id, field));
            this.trackedFields.add(key);
        }
    }

    public synchronized void addInstance(ResourceLocation id, Field field, Object instance) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalStateException("Can't track registry instance field: Must not be static: " + field);
        }
        if (!field.getDeclaringClass().isAssignableFrom(instance.getClass())) {
            throw new IllegalStateException("Can't track registry instance field: Instance object is of type " + instance.getClass() + ", expected " + field.getDeclaringClass() + ".");
        }
        TrackedFieldKey key = TrackedFieldKey.create(field, instance);
        if (!this.trackedFields.contains(key)) {
            this.instanceFields.add(new TrackedInstanceField(id, field, new WeakReference<Object>(instance)));
            this.trackedFields.add(key);
        }
    }

    public synchronized void addAction(ResourceLocation id, Object instance, Consumer<T> action) {
        this.actions.add(new TrackedInstanceAction<T>(id, new WeakReference<Object>(instance), action));
    }

    public synchronized void apply(Predicate<ResourceLocation> changed, @Nullable Predicate<Object> instanceChanged, Consumer<Runnable> enqueue, Consumer<Object> valueUpdate) {
        if (changed.test(this.registryId)) {
            Object instance;
            if (instanceChanged == null) {
                for (TrackedStaticField trackedStaticField : this.staticFields) {
                    this.updateFrom(trackedStaticField.id(), trackedStaticField.field(), null, enqueue, valueUpdate);
                }
            }
            Iterator<Record> itr = this.instanceFields.iterator();
            while (itr.hasNext()) {
                TrackedInstanceField trackedInstanceField = itr.next();
                instance = trackedInstanceField.instance().get();
                if (instance == null) {
                    itr.remove();
                    continue;
                }
                if (instanceChanged != null && !instanceChanged.test(instance)) continue;
                this.updateFrom(trackedInstanceField.id(), trackedInstanceField.field(), instance, enqueue, valueUpdate);
            }
            itr = this.actions.iterator();
            while (itr.hasNext()) {
                TrackedInstanceAction trackedInstanceAction = (TrackedInstanceAction)itr.next();
                instance = trackedInstanceAction.instance().get();
                if (instance == null) {
                    itr.remove();
                    continue;
                }
                Object value = this.registry.getValue(trackedInstanceAction.id());
                if (value == null) {
                    throw new IllegalStateException("Tracked registry object not present for action: " + this.registryId + " / " + trackedInstanceAction.id() + ".");
                }
                if (instanceChanged != null && !instanceChanged.test(instance)) continue;
                trackedInstanceAction.action().accept(value);
            }
        }
    }

    public int hashCode() {
        return this.registryId.hashCode();
    }

    private void updateFrom(ResourceLocation id, Field field, Object instance, Consumer<Runnable> enqueue, Consumer<Object> valueUpdate) {
        try {
            field.setAccessible(true);
            Object oldValue = field.get(instance);
            Object value = this.registry.getValue(id);
            if (value == null) {
                throw new IllegalStateException("Tracked registry object not present: " + this.registryId + " / " + id + ", was " + oldValue + " before.");
            }
            if (!field.getType().isAssignableFrom(value.getClass())) {
                throw new IllegalStateException("Tracked registry object has invalid type: " + this.registryId + " / " + id + ", was " + oldValue + " before. Probably a failed registry replacement. Expected: " + field.getType());
            }
            if (value != oldValue) {
                if (Modifier.isFinal(field.getModifiers())) {
                    try {
                        ReflectionHacks.setFinalField(field, instance, value);
                    }
                    catch (Exception e) {
                        throw new ReflectiveOperationException("Failed to set final tracked registry field " + field, e);
                    }
                } else {
                    field.setAccessible(true);
                    field.set(instance, value);
                }
                enqueue.accept(() -> {
                    ModX patt7089$temp;
                    Optional<ModInternal> modInternal = ModInternal.get(id.m_135827_());
                    if (modInternal.isPresent() && (patt7089$temp = modInternal.get().instance()) instanceof ModXRegistration) {
                        ModXRegistration mod = (ModXRegistration)patt7089$temp;
                        RegistrationContext ctx = new RegistrationContext(mod, id, this.registry.getRegistryKey());
                        try {
                            if (value instanceof Registerable) {
                                Registerable registerable = (Registerable)value;
                                registerable.initTracking(ctx, new TrackingInstance(id, value));
                            } else if (value instanceof MultiRegisterable) {
                                MultiRegisterable registerable = (MultiRegisterable)value;
                                registerable.initTracking(ctx, new TrackingInstance(id, value));
                            }
                        }
                        catch (ReflectiveOperationException e) {
                            LibX.logger.error("Failed to update instance tracking for " + value + " (" + id + "/" + this.registry.getRegistryName() + ")", (Throwable)e);
                        }
                    }
                });
                valueUpdate.accept(value);
            }
        }
        catch (ReflectiveOperationException e) {
            LibX.logger.error("Failed to update registry object: " + this.registryId + " / " + id, (Throwable)e);
        }
    }

    private record TrackedFieldKey(Field field, @Nullable WeakReference<Object> instance, int instanceHash) {
        public static TrackedFieldKey create(Field field, @Nullable Object instance) {
            return new TrackedFieldKey(field, instance == null ? null : new WeakReference<Object>(instance), System.identityHashCode(instance));
        }

        @Override
        public int hashCode() {
            return this.instanceHash ^ this.field.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TrackedFieldKey)) {
                return false;
            }
            TrackedFieldKey key = (TrackedFieldKey)obj;
            if (!Objects.equals(this.field(), key.field())) {
                return false;
            }
            if (this.instance() == null && key.instance() == null) {
                return true;
            }
            if (this.instance() == null || key.instance() == null) {
                return false;
            }
            Object instance = this.instance().get();
            return instance != null && key.instance().refersTo(instance);
        }
    }

    private record TrackedStaticField(ResourceLocation id, Field field) {
    }

    private record TrackedInstanceField(ResourceLocation id, Field field, WeakReference<Object> instance) {
    }

    private record TrackedInstanceAction<T>(ResourceLocation id, WeakReference<Object> instance, Consumer<T> action) {
    }
}

