/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.phys.Vec2;
import org.lwjgl.opengl.GL11;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.render.target.RenderJob;
import org.moddingx.libx.render.target.RenderJobFailedException;

public class JobRenderer {
    public static NativeImage renderJob(RenderJob job) {
        int width = job.width();
        int height = job.height();
        boolean overlay = job.usesOverlay();
        int maxTextureSize = GL11.glGetInteger((int)3379);
        if (width > maxTextureSize || height > maxTextureSize) {
            throw new RenderJobFailedException(RenderJobFailedException.Reason.TEXTURE_TOO_LARGE, "Maximum texture size exceeded: " + width + "x" + height + ", maximum is " + maxTextureSize + "x" + maxTextureSize);
        }
        TextureTarget target = new TextureTarget(width, height, true, Minecraft.f_91002_);
        target.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        target.m_83954_(true);
        JobRenderer.resetDepthState();
        target.m_83947_(true);
        RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
        target.m_83947_(true);
        FogRenderer.m_109017_();
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        RenderSystem.m_69949_((int)0, (int)0, (int)width, (int)height);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_166854_(job.setupModelViewMatrix());
        RenderSystem.m_157182_();
        Matrix4f projectionMatrix = job.setupProjectionMatrix();
        RenderSystem.m_157425_((Matrix4f)projectionMatrix);
        Lighting.m_84931_();
        RenderSystem.m_69453_();
        RenderHelper.resetColor();
        Matrix4f transformationMatrix = overlay ? modelViewStack.m_85850_().m_85861_().m_27658_() : null;
        PoseStack poseStack = new PoseStack();
        job.setupTransformation(poseStack);
        if (overlay) {
            transformationMatrix.m_27644_(poseStack.m_85850_().m_85861_());
        }
        RenderBuffers buffers = new RenderBuffers();
        job.render(poseStack, (MultiBufferSource)buffers.m_110104_());
        buffers.m_110104_().m_109911_();
        if (overlay) {
            target.m_83947_(true);
            FogRenderer.m_109017_();
            JobRenderer.resetDepthState();
            RenderSystem.m_69949_((int)0, (int)0, (int)width, (int)height);
            modelViewStack.m_166856_();
            modelViewStack.m_166854_(job.setupModelViewMatrix());
            RenderSystem.m_157182_();
            RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)width, (float)0.0f, (float)height, (float)1000.0f, (float)3000.0f));
            PoseStack overlayPoseStack = new PoseStack();
            Lighting.m_84931_();
            ProjectorImpl projector = new ProjectorImpl(projectionMatrix, transformationMatrix, 0, 0, width, height);
            job.renderOverlay(overlayPoseStack, (MultiBufferSource)buffers.m_110104_(), projector);
            buffers.m_110104_().m_109911_();
        }
        JobRenderer.resetDepthState();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        NativeImage img = JobRenderer.takeNonOpaqueScreenshot((RenderTarget)target);
        target.m_83970_();
        return img;
    }

    private static void resetDepthState() {
        RenderSystem.m_69430_((double)1.0);
        RenderSystem.m_69456_((int)515);
        GL11.glFrontFace((int)2305);
    }

    private static NativeImage takeNonOpaqueScreenshot(RenderTarget fb) {
        NativeImage img = new NativeImage(fb.f_83915_, fb.f_83916_, false);
        RenderSystem.m_69396_((int)fb.m_83975_());
        img.m_85045_(0, false);
        img.m_85122_();
        return img;
    }

    private static class ProjectorImpl
    implements RenderJob.Projector {
        private final Matrix4f projection;
        private final Matrix4f transformation;
        private final int viewportX;
        private final int viewportY;
        private final int viewportWidth;
        private final int viewportHeight;

        public ProjectorImpl(@Nonnull Matrix4f projection, @Nonnull Matrix4f transformation, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
            this.projection = projection;
            this.transformation = transformation;
            this.viewportX = viewportX;
            this.viewportY = viewportY;
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
        }

        @Override
        public Vec2 projectPoint(Vector3f point) {
            Vector4f vec4 = new Vector4f(point);
            vec4.m_123607_(this.transformation);
            vec4.m_123607_(this.projection);
            if (!Double.isNaN(vec4.m_123617_()) && !Double.isInfinite(vec4.m_123617_()) && Math.abs(vec4.m_123617_()) >= 1.0E-6f) {
                vec4.m_123602_(vec4.m_123601_() / vec4.m_123617_(), vec4.m_123615_() / vec4.m_123617_(), vec4.m_123616_() / vec4.m_123617_(), 1.0f);
            }
            float wx = (float)this.viewportX + (float)this.viewportWidth * ((vec4.m_123601_() + 1.0f) / 2.0f);
            float wy = (float)this.viewportY + (float)this.viewportHeight * (1.0f - (vec4.m_123615_() + 1.0f) / 2.0f);
            return new Vec2(wx, wy);
        }
    }
}

