/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.registration;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import org.moddingx.libx.annotation.meta.SuperChainRequired;
import org.moddingx.libx.registration.MultiRegisterable;
import org.moddingx.libx.registration.RegistrationContext;
import org.moddingx.libx.registration.SetupContext;

public interface Registerable {
    default public void registerCommon(SetupContext ctx) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void registerClient(SetupContext ctx) {
    }

    @SuperChainRequired
    default public void registerAdditional(RegistrationContext ctx, EntryCollector builder) {
    }

    @SuperChainRequired
    default public void initTracking(RegistrationContext ctx, TrackingCollector builder) throws ReflectiveOperationException {
    }

    public static interface TrackingCollector {
        public void track(IForgeRegistry<?> var1, Field var2);

        public void trackNamed(IForgeRegistry<?> var1, String var2, Field var3);

        public <T> void run(IForgeRegistry<T> var1, Consumer<T> var2);

        public <T> void runNamed(IForgeRegistry<T> var1, String var2, Consumer<T> var3);
    }

    public static interface EntryCollector {
        public <T> void register(@Nullable ResourceKey<? extends Registry<T>> var1, T var2);

        public <T> void registerNamed(@Nullable ResourceKey<? extends Registry<T>> var1, String var2, T var3);

        public <T> void registerMulti(@Nullable ResourceKey<? extends Registry<T>> var1, MultiRegisterable<T> var2);

        public <T> void registerMultiNamed(@Nullable ResourceKey<? extends Registry<T>> var1, String var2, MultiRegisterable<T> var3);

        public <T> Holder<T> createHolder(@Nullable ResourceKey<? extends Registry<T>> var1, T var2);

        public <T> Holder<T> createNamedHolder(@Nullable ResourceKey<? extends Registry<T>> var1, String var2, T var3);
    }
}

