/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.PlatformProxy;

public enum AnimalOwnerProvider implements IEntityComponentProvider,
IServerDataProvider<Entity>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        String name = null;
        if (accessor.getServerData().m_128441_("OwnerName")) {
            name = accessor.getServerData().m_128461_("OwnerName");
        } else {
            Entity entity = accessor.getEntity();
            UUID ownerUUID = null;
            if (entity instanceof OwnableEntity) {
                ownerUUID = ((OwnableEntity)entity).m_21805_();
            } else if (entity instanceof AbstractHorse) {
                ownerUUID = ((AbstractHorse)entity).m_30615_();
            }
            if (ownerUUID == null) {
                return;
            }
            name = PlatformProxy.getLastKnownUsername(ownerUUID);
            if (name == null) {
                name = "???";
            }
        }
        tooltip.add((Component)Component.m_237110_((String)"jade.owner", (Object[])new Object[]{name}));
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, Entity entity, boolean showDetails) {
        String name;
        if (world.m_7654_().m_7779_(player.m_36316_())) {
            return;
        }
        UUID ownerUUID = null;
        if (entity instanceof OwnableEntity) {
            ownerUUID = ((OwnableEntity)entity).m_21805_();
        } else if (entity instanceof AbstractHorse) {
            ownerUUID = ((AbstractHorse)entity).m_30615_();
        }
        if (ownerUUID != null && (name = PlatformProxy.getLastKnownUsername(ownerUUID)) != null) {
            data.m_128359_("OwnerName", name);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_ANIMAL_OWNER;
    }
}

