/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.events.StructurePlacementClient;
import questsadditions.tasks.TasksRegistry;

public class StructureTask
extends Task {
    public String name = "";
    public boolean hasCustomPicture;
    public boolean layer = true;
    public ItemStack item = ItemStack.f_41583_;
    public boolean rightclick_validation;
    public boolean ignoreState;

    public StructureTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.STRUCTURE;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("name", this.name);
        nbt.m_128379_("hasCustomPicture", this.hasCustomPicture);
        nbt.m_128379_("layer", this.layer);
        nbt.m_128379_("ignoreState", this.ignoreState);
        nbt.m_128379_("rightclick", this.rightclick_validation);
        if (this.rightclick_validation) {
            NBTUtils.write((CompoundTag)nbt, (String)"item", (ItemStack)this.item);
        }
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.name = nbt.m_128461_("name");
        this.hasCustomPicture = nbt.m_128471_("hasCustomPicture");
        this.layer = nbt.m_128471_("layer");
        this.ignoreState = nbt.m_128471_("ignoreState");
        this.rightclick_validation = nbt.m_128471_("rightclick");
        if (this.rightclick_validation) {
            this.item = NBTUtils.read((CompoundTag)nbt, (String)"item");
        }
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.name, Short.MAX_VALUE);
        buffer.writeBoolean(this.hasCustomPicture);
        buffer.writeBoolean(this.layer);
        buffer.writeBoolean(this.ignoreState);
        buffer.writeBoolean(this.rightclick_validation);
        if (this.rightclick_validation) {
            FTBQuestsNetHandler.writeItemType((FriendlyByteBuf)buffer, (ItemStack)this.item);
        }
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.name = buffer.m_130136_(Short.MAX_VALUE);
        this.hasCustomPicture = buffer.readBoolean();
        this.layer = buffer.readBoolean();
        this.ignoreState = buffer.readBoolean();
        this.rightclick_validation = buffer.readBoolean();
        if (this.rightclick_validation) {
            this.item = FTBQuestsNetHandler.readItemType((FriendlyByteBuf)buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("name", this.name, v -> {
            this.name = v;
        }, "");
        config.addBool("hasCustomPicture", this.hasCustomPicture, v -> {
            this.hasCustomPicture = v;
        }, false);
        config.addBool("layer", this.layer, v -> {
            this.layer = v;
        }, true);
        config.addBool("ignoreState", this.ignoreState, v -> {
            this.ignoreState = v;
        }, false);
        config.addBool("rightclick", this.rightclick_validation, v -> {
            this.rightclick_validation = v;
        }, false);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.m_237110_((String)"questsadditions.task.structure.title", (Object[])new Object[]{this.name});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        list.blankLine();
        if (StructurePlacementClient.isLocked()) {
            list.add((Component)Component.m_237115_((String)"ftbquests.task.click_to_submit").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else {
            list.add((Component)Component.m_237115_((String)"questsadditions.structure_task.show").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.hasCustomPicture) {
            return Icon.getIcon((String)("questsadditions:textures/structure_icons/" + this.name + ".png"));
        }
        return super.getAltIcon();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        if (!ClientQuestFile.INSTANCE.self.isCompleted((QuestObject)this)) {
            StructurePlacementClient.toggleShowStructure(this.name, this.layer, this);
        }
    }
}

