/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.annotations.ProvideRecipes;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.IRecipeProvider;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.api.proxy.IProxy;
import org.zeith.hammerlib.compat.base.CompatList;
import org.zeith.hammerlib.compat.base._hl.BaseHLCompat;
import org.zeith.hammerlib.core.ConfigHL;
import org.zeith.hammerlib.core.adapter.ConfigAdapter;
import org.zeith.hammerlib.core.adapter.CreativeTabAdapter;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.command.CommandHammerLib;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.proxy.HLClientProxy;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.tiles.tooltip.own.impl.TooltipRenderEngine;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.hammerlib.util.ZeithLinkRepository;
import org.zeith.hammerlib.util.charging.ItemChargeHelper;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@Mod(value="hammerlib")
public class HammerLib {
    public static final Logger LOG = LogManager.getLogger((String)"HammerLib");
    public static final HLCommonProxy PROXY = (HLCommonProxy)IProxy.create(() -> HLClientProxy::new, () -> HLCommonProxy::new);
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    public static final CompatList<BaseHLCompat> HL_COMPAT_LIST = CompatList.gather(BaseHLCompat.class);
    public static boolean logHLEvents = String.valueOf(System.getProperty("hammerlib.logevents")).toLowerCase(Locale.ROOT).contains("true");

    public HammerLib() {
        CommonMessages.printMessageOnIllegalRedistribution(HammerLib.class, LOG, "HammerLib", "https://www.curseforge.com/minecraft/mc-mods/hammer-lib");
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        PROXY.construct(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        LanguageAdapter.registerMod("hammerlib");
        TagsHL.init();
        ZeithLinkRepository.initialize();
        ItemChargeHelper.setup();
        ScanDataHelper.lookupAnnotatedObjects(ProvideRecipes.class).forEach(data -> {
            IRecipeProvider provider;
            FMLModContainer ow = data.getOwnerMod().orElse(null);
            if (ow == null) {
                LOG.info("Skipping mod-less @ProvideRecipes annotation in " + data.getOwnerClass());
                return;
            }
            Class<?> c = data.getOwnerClass();
            if (IRecipeProvider.class.isAssignableFrom(c) && (provider = (IRecipeProvider)UnsafeHacks.newInstance(c)) != null) {
                EVENT_BUS.addListener(provider::provideRecipes);
                EVENT_BUS.addListener(provider::spoofRecipes);
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(SimplyRegister.class).forEach(data -> {
            if (data.getTargetType() == ElementType.TYPE) {
                data.getOwnerMod().ifPresent(mc -> {
                    LOG.info("Hooked {} from {} to register it's stuff.", (Object)data.clazz(), (Object)mc.getModId());
                    mc.getEventBus().addListener(event -> RegistryAdapter.register(event, data.getOwnerClass(), mc, data.getProperty("prefix").map(Objects::toString).orElse("")));
                });
            }
        });
        ConfigAdapter.setup();
        List bothSides = Stream.of(Dist.values()).map(dst -> new ModAnnotation.EnumHolder("Lnet/minecraftforge/itf/distmarker/Dist;", dst.name())).collect(Collectors.toList());
        ScanDataHelper.lookupAnnotatedObjects(Setup.class).forEach(data -> {
            List lst;
            Object side = data.getProperty("side").orElse(bothSides);
            if (side instanceof List && !(lst = (List)side).isEmpty()) {
                for (Object o : lst) {
                    if (!(o instanceof ModAnnotation.EnumHolder)) continue;
                    ModAnnotation.EnumHolder h = (ModAnnotation.EnumHolder)o;
                    if (!FMLEnvironment.dist.name().equals(h.getValue())) continue;
                    if (data.getTargetType() == ElementType.METHOD) {
                        LOG.info("Injecting setup into " + data.clazz().getClassName());
                        data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.setup(event, data.getOwnerClass(), data.getMemberName())));
                    }
                    break;
                }
            } else {
                LOG.warn("What the hell is this? {}->{}", (Object)data.parent.clazz(), (Object)data.getMemberName());
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(ClientSetup.class).forEach(data -> {
            if (data.getTargetType() == ElementType.METHOD) {
                LOG.info("Injecting client-setup into " + data.clazz().getClassName());
                data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.clientSetup(event, data.getOwnerClass(), data.getMemberName())));
            }
        });
        NBTSerializationHelper.construct();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation("hammerlib", path);
    }

    @SubscribeEvent
    public void constructMod(FMLConstructModEvent e0) {
        ModList.get().forEachModContainer((modid, container) -> {
            if (container instanceof FMLModContainer) {
                FMLModContainer ctr = (FMLModContainer)container;
                IEventBus bus = ctr.getEventBus();
                bus.addListener(e -> ctr.getEventBus().post((Event)new FMLFingerprintCheckEvent((ModContainer)ctr)));
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent e) {
        PROXY.clientSetup();
    }

    @SubscribeEvent
    public void checkFingerprint(FMLFingerprintCheckEvent e) {
        CommonMessages.printMessageOnFingerprintViolation(e, "97e852e9b3f01b83574e8315f7e77651c6605f2b455919a7319e9869564f013c", LOG, "HammerLib", "https://www.curseforge.com/minecraft/mc-mods/hammer-lib");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(RegisterGuiOverlaysEvent e) {
        e.registerAboveAll("tooltip_engine", (IGuiOverlay)new TooltipRenderEngine());
    }

    @SubscribeEvent
    public void finish(FMLLoadCompleteEvent e) {
        PROXY.finishLoading();
        CreativeTabAdapter.deque();
    }

    public void registerCommands(RegisterCommandsEvent e) {
        CommandHammerLib.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public static boolean postEvent(Event evt) {
        ConfigHL cfgs = ConfigHL.INSTANCE.getCurrent();
        if (logHLEvents || cfgs != null && cfgs.internal.logHLBusEvents) {
            LOG.info("[HammerLib.postEvent] " + evt);
        }
        return EVENT_BUS.post(evt);
    }

    public static boolean postEvent(Event evt, IEventBusInvokeDispatcher dispatcher) {
        ConfigHL cfgs = ConfigHL.INSTANCE.getCurrent();
        if (logHLEvents || cfgs != null && cfgs.internal.logHLBusEvents) {
            LOG.info("[HammerLib.postEvent] " + evt);
        }
        return EVENT_BUS.post(evt, dispatcher);
    }
}

