/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.actions.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.abstractions.actions.ILevelActionType;
import org.zeith.hammerlib.abstractions.actions.RunnableLevelAction;
import org.zeith.hammerlib.annotations.ExposedToLevelAction;
import org.zeith.hammerlib.core.init.LevelActionTypesHL;
import org.zeith.hammerlib.util.java.reflection.SerializableMethodHandle;

public class MethodHandleLevelAction
extends RunnableLevelAction {
    protected final SerializableMethodHandle handle;

    public MethodHandleLevelAction(SerializableMethodHandle handle) {
        this(LevelActionTypesHL.METHOD_HANDLE_TYPE, handle);
        if (!handle.isResolved()) {
            HammerLib.LOG.warn("Warning: created unresolved method handle level action! {}", (Object)handle);
        }
    }

    public MethodHandleLevelAction(ILevelActionType type, SerializableMethodHandle handle) {
        super(type);
        this.handle = handle != null && handle.isResolved() ? handle : null;
    }

    public MethodHandleLevelAction(ILevelActionType type, Level level, CompoundTag tag) {
        this(type, new SerializableMethodHandle(tag.m_128469_("Target")));
    }

    @Override
    public void run(ServerLevel level) {
        if (this.handle == null || !this.handle.isResolved()) {
            return;
        }
        if (!this.handle.getMethod().isAnnotationPresent(ExposedToLevelAction.class)) {
            HammerLib.LOG.warn("Completely ignored non-exposed call method handle: {}", (Object)this.handle.serializeNBT());
            return;
        }
        try {
            this.handle.call();
        }
        catch (SerializableMethodHandle.MethodHandleInvocationException e) {
            HammerLib.LOG.error("Failed to invoke {}", (Object)this.handle);
        }
    }

    @Override
    public CompoundTag write(Level level) {
        CompoundTag nbt = new CompoundTag();
        if (this.handle != null && this.handle.isResolved()) {
            nbt.m_128365_("Target", (Tag)this.handle.serializeNBT());
        }
        return nbt;
    }
}

