/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting.building;

import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public abstract class GeneralRecipeBuilder<T extends IGeneralRecipe, R extends GeneralRecipeBuilder<T, R>> {
    protected final IRecipeRegistrationEvent<T> registrar;
    protected ResourceLocation identifier;

    public GeneralRecipeBuilder(IRecipeRegistrationEvent<T> registrar) {
        this.registrar = registrar;
    }

    public R id(ResourceLocation identifier) {
        this.identifier = identifier;
        return (R)this;
    }

    protected abstract ResourceLocation generateId();

    protected ResourceLocation getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        this.identifier = this.generateId();
        return this.identifier;
    }

    protected abstract void validate() throws IllegalStateException;

    protected abstract T createRecipe() throws IllegalStateException;

    public T build() {
        this.validate();
        return this.createRecipe();
    }

    public void register() {
        this.validate();
        this.registrar.register(this.getIdentifier(), this.createRecipe());
    }

    public void registerIf(BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            this.register();
        }
    }

    public void registerIf(Predicate<ResourceLocation> condition) {
        if (condition.test(this.identifier)) {
            this.register();
        }
    }
}

