/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting.impl;

import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.api.crafting.IBaseIngredient;
import org.zeith.hammerlib.api.crafting.ICraftingResult;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.impl.EnergyIngredient;
import org.zeith.hammerlib.api.crafting.impl.FluidStackIngredient;
import org.zeith.hammerlib.api.crafting.impl.FluidStackResult;
import org.zeith.hammerlib.api.crafting.impl.ForgeEnergyResult;
import org.zeith.hammerlib.api.crafting.impl.ItemStackResult;
import org.zeith.hammerlib.api.crafting.impl.MCIngredient;
import org.zeith.hammerlib.api.energy.EnergyUnit;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.util.charging.fe.FECharge;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredient;

public class BaseGeneralRecipe
implements IGeneralRecipe {
    public final ICraftingResult<?> output;
    public final NonNullList<IBaseIngredient> ingredients;

    public BaseGeneralRecipe(ICraftingResult<?> output, NonNullList<IBaseIngredient> ingredients) {
        this.output = output;
        this.ingredients = ingredients;
    }

    @Override
    public NonNullList<IBaseIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ICraftingResult<?> getResult() {
        return this.output;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final NonNullList<Ingredient> inputItems = NonNullList.m_122779_();
        private final NonNullList<FluidIngredient> inputFluid = NonNullList.m_122779_();
        private ICraftingResult<?> output;
        private double FE;

        public Builder addInput(Ingredient ing) {
            this.inputItems.add((Object)ing);
            return this;
        }

        public Builder addInput(TagKey<Item> tag) {
            this.inputItems.add((Object)RecipeHelper.fromTag(tag));
            return this;
        }

        public Builder addInput(FluidIngredient stack) {
            this.inputFluid.add((Object)stack);
            return this;
        }

        public Builder setEnergy(double amount, EnergyUnit unit) {
            this.FE = unit.getInFE(amount);
            return this;
        }

        public Builder addEnergy(double amount, EnergyUnit unit) {
            this.FE += unit.getInFE(amount);
            return this;
        }

        public Builder withOutput(ItemStack stack) {
            this.output = new ItemStackResult(stack);
            return this;
        }

        public Builder withOutput(FluidStack stack) {
            this.output = new FluidStackResult(stack);
            return this;
        }

        public Builder withOutput(int FE) {
            this.output = new ForgeEnergyResult(new FECharge(FE));
            return this;
        }

        public Builder withOutput(ICraftingResult<?> stack) {
            this.output = stack;
            return this;
        }

        public double getEnergy(EnergyUnit unit) {
            return unit.getFromFE(this.FE);
        }

        public BaseGeneralRecipe build() {
            NonNullList ings = NonNullList.m_122779_();
            if (this.FE > 0.0) {
                ings.add((Object)new EnergyIngredient(this.FE, EnergyUnit.RF));
            }
            for (FluidIngredient stack : this.inputFluid) {
                ings.add((Object)new FluidStackIngredient(stack));
            }
            for (Ingredient ing : this.inputItems) {
                ings.add((Object)new MCIngredient(ing));
            }
            return new BaseGeneralRecipe(this.output, (NonNullList<IBaseIngredient>)ings);
        }
    }
}

