/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.lighting;

import com.mojang.math.Vector3d;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import org.zeith.hammerlib.client.utils.IGLBufferStream;
import org.zeith.hammerlib.client.utils.IGLWritable;

public class ColoredLight
implements IGLWritable {
    public static final int FLOAT_SIZE = 8;
    public float x;
    public float y;
    public float z;
    public float r;
    public float g;
    public float b;
    public float a;
    public float radius;

    public ColoredLight(float x, float y, float z, float r, float g, float b, float a, float radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.radius = radius;
    }

    public ColoredLight reposition(Entity entity, float partialTicks) {
        this.x = (float)(entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)partialTicks);
        this.y = (float)(entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)partialTicks);
        this.z = (float)(entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)partialTicks);
        return this;
    }

    @Override
    public int getFloatSize() {
        return 8;
    }

    @Override
    public void writeFloats(IGLBufferStream<Float> stream) {
        stream.putAll((Float[])new Float[]{Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a)});
        stream.putAll((Float[])new Float[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)});
        stream.put(Float.valueOf(this.radius));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float x = Float.NaN;
        private float y = Float.NaN;
        private float z = Float.NaN;
        private float r = Float.NaN;
        private float g = Float.NaN;
        private float b = Float.NaN;
        private float a = Float.NaN;
        private float radius = Float.NaN;

        public Builder pos(Vec3i pos) {
            return this.pos((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        }

        public Builder pos(Vector3d pos) {
            return this.pos(pos.f_86214_, pos.f_86215_, pos.f_86216_);
        }

        public Builder pos(Entity e) {
            return this.pos(e.m_20185_() + (double)(e.m_20205_() / 2.0f), e.m_20186_() + (double)(e.m_20206_() / 2.0f), e.m_20189_() + (double)(e.m_20205_() / 2.0f));
        }

        public Builder pos(Entity e, float partialTime) {
            return this.pos(e.f_19790_ + (e.m_20185_() - e.f_19790_) * (double)partialTime + (double)(e.m_20205_() / 2.0f), e.f_19791_ + (e.m_20186_() - e.f_19791_) * (double)partialTime + (double)(e.m_20206_() / 2.0f), e.f_19792_ + (e.m_20189_() - e.f_19792_) * (double)partialTime + (double)(e.m_20205_() / 2.0f));
        }

        public Builder pos(double x, double y, double z) {
            return this.pos((float)x, (float)y, (float)z);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder color(Vector3d c, float alpha) {
            return this.color((float)c.f_86214_, (float)c.f_86215_, (float)c.f_86216_, alpha);
        }

        public Builder color(Vector3d c) {
            return this.color((float)c.f_86214_, (float)c.f_86215_, (float)c.f_86216_, 1.0f);
        }

        public Builder color(int c, boolean hasAlpha) {
            return this.color(this.extract(c, 2), this.extract(c, 1), this.extract(c, 0), hasAlpha ? this.extract(c, 3) : 1.0f);
        }

        private float extract(int i, int idx) {
            return (float)(i >> idx * 8 & 0xFF) / 255.0f;
        }

        public Builder color(float r, float g, float b) {
            return this.color(r, g, b, 1.0f);
        }

        public Builder color(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Builder alpha(int alpha) {
            return this.alpha((float)alpha / 255.0f);
        }

        public Builder alpha(float alpha) {
            this.a = alpha;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public ColoredLight build() {
            if (Float.isFinite(this.x) && Float.isFinite(this.y) && Float.isFinite(this.z) && Float.isFinite(this.r) && Float.isFinite(this.g) && Float.isFinite(this.b) && Float.isFinite(this.a) && Float.isFinite(this.radius)) {
                return new ColoredLight(this.x, this.y, this.z, this.r, this.g, this.b, this.a, this.radius);
            }
            throw new IllegalArgumentException("Position, color, and radius must be set, and cannot be infinite");
        }
    }
}

