/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.recipes;

import com.google.common.base.Suppliers;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public abstract class RecipeBuilderExtension {
    private static final Supplier<Map<Class<?>, Function<RegisterRecipesEvent, ? extends RecipeBuilderExtension>>> REGISTRY = Suppliers.memoize(() -> (Map)Util.m_137469_(new ConcurrentHashMap(), map -> {
        for (Class<RecipeBuilderExtension> type : ScanDataHelper.lookupAnnotatedTypes(RegisterExt.class, RecipeBuilderExtension.class)) {
            try {
                Constructor<RecipeBuilderExtension> ctor = type.getDeclaredConstructor(RegisterRecipesEvent.class);
                ctor.setAccessible(true);
                Function<RegisterRecipesEvent, RecipeBuilderExtension> generator = evt -> {
                    try {
                        return (RecipeBuilderExtension)ctor.newInstance(evt);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        HammerLib.LOG.error("Failed to attach " + type.getName() + " to recipe registration.");
                        return null;
                    }
                };
                map.put(type, generator);
            }
            catch (ReflectiveOperationException roe) {
                HammerLib.LOG.error("Failed to register " + type.getName() + " constructor.");
            }
        }
    }));
    protected final RegisterRecipesEvent event;

    public RecipeBuilderExtension(RegisterRecipesEvent event) {
        this.event = event;
    }

    public static <T extends RecipeBuilderExtension> void register(Class<T> type, Function<RegisterRecipesEvent, T> factory) {
        if (RecipeBuilderExtension.class.equals(type) || !RecipeBuilderExtension.class.isAssignableFrom(type)) {
            return;
        }
        REGISTRY.get().put(type, factory);
    }

    public static Map<Class<?>, RecipeBuilderExtension> attach(RegisterRecipesEvent evt) {
        return REGISTRY.get().entrySet().stream().map(e -> {
            try {
                return Tuples.mutable((Class)e.getKey(), (RecipeBuilderExtension)((Function)e.getValue()).apply(evt));
            }
            catch (Exception err) {
                HammerLib.LOG.error("Failed to decode recipe builder extension of type " + e.getKey());
                return null;
            }
        }).filter(e -> e != null && ((Class)e.a()).isInstance(e.b())).collect(Collectors.toMap(Tuple2::a, Tuple2::b));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RegisterExt {
    }
}

