/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.FluidTextureType;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class FluidRendererHelper {
    public static void renderFluidInGui(PoseStack pose, FluidStack fluid, FluidTextureType type, float full, float x, float y, float width, float height) {
        if (!fluid.isEmpty()) {
            TextureAtlasSprite sprite = FluidRendererHelper.getFluidTexture(fluid, type);
            int argb = FluidRendererHelper.getColorARGB(fluid);
            float a = ColorHelper.getAlpha(argb);
            float r = ColorHelper.getRed(argb);
            float g = ColorHelper.getGreen(argb);
            float b = ColorHelper.getBlue(argb);
            float heightF = height * full;
            if (heightF > 0.0f) {
                FXUtils.bindTexture(InventoryMenu.f_39692_);
                Tesselator tess = Tesselator.m_85913_();
                BufferBuilder bb = tess.m_85915_();
                bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                float[] colors = (float[])RenderSystem.m_157197_().clone();
                RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
                Matrix4f pose4f = pose.m_85850_().m_85861_();
                float minX = sprite.m_118367_(0.0);
                float maxX = sprite.m_118367_(16.0);
                float maxY = sprite.m_118393_(16.0);
                float ys = 0.0f;
                while (heightF > 0.0f) {
                    float ch = Math.min(width, heightF);
                    float yCoord = y + height - ch - ys;
                    float minY = sprite.m_118393_((double)(16.0f - Math.min(16.0f, heightF * 16.0f / width)));
                    bb.m_85982_(pose4f, x, yCoord + ch, 0.0f).m_7421_(minX, maxY).m_5752_();
                    bb.m_85982_(pose4f, x + width, yCoord + ch, 0.0f).m_7421_(maxX, maxY).m_5752_();
                    bb.m_85982_(pose4f, x + width, yCoord, 0.0f).m_7421_(maxX, minY).m_5752_();
                    bb.m_85982_(pose4f, x, yCoord, 0.0f).m_7421_(minX, minY).m_5752_();
                    heightF -= ch;
                    ys += ch;
                }
                tess.m_85914_();
                RenderSystem.m_157429_((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
            }
        }
    }

    public static TextureAtlasSprite getBaseFluidTexture(@NotNull Fluid fluid, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation spriteLocation = type == FluidTextureType.STILL ? properties.getStillTexture() : properties.getFlowingTexture();
        return FluidRendererHelper.getSprite(spriteLocation);
    }

    public static int getColorARGB(@NotNull FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static TextureAtlasSprite getFluidTexture(@NotNull FluidStack fluidStack, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        return FluidRendererHelper.getSprite(type == FluidTextureType.STILL ? properties.getStillTexture(fluidStack) : properties.getFlowingTexture(fluidStack));
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
    }

    public static int calculateGlowLight(int combinedLight, @NotNull FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : FluidRendererHelper.calculateGlowLight(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }
}

