/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render.item;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.client.render.item.RecenterFilter;
import org.zeith.hammerlib.compat.jei.IJeiPluginHL;
import org.zeith.hammerlib.core.ConfigHL;
import org.zeith.hammerlib.proxy.HLClientProxy;
import org.zeith.hammerlib.util.java.Cast;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Stack2ImageRenderer {
    private static final List<RenderQueueItem> QUEUE = new ArrayList<RenderQueueItem>();

    public static void queueRenderer(Component type, ItemStack stack, int size, File targetIn) {
        String origin = targetIn.getAbsolutePath();
        int itr = 1;
        while (targetIn.isFile()) {
            int dot = origin.lastIndexOf(".");
            if (dot >= 0) {
                targetIn = new File(origin.substring(0, dot) + " (" + ++itr + ")." + origin.substring(dot + 1));
                continue;
            }
            targetIn = new File(origin + " (" + ++itr + ")");
        }
        File target = targetIn;
        Stack2ImageRenderer.renderItemStack(type, size, size, stack, image -> Util.m_183992_().execute(() -> {
            try {
                Files.createDirectories(target.toPath().getParent(), new FileAttribute[0]);
                image.m_85056_(target);
                image.close();
                BufferedImage buffered = ImageIO.read(target);
                RecenterFilter.recenter(buffered).thenAccept(result -> Util.m_183992_().execute(() -> {
                    try {
                        ImageIO.write((RenderedImage)result, "png", target);
                    }
                    catch (Exception exception) {
                        HammerLib.LOG.warn("Couldn't save render", (Throwable)exception);
                    }
                }));
            }
            catch (Exception exception) {
                HammerLib.LOG.warn("Couldn't save render", (Throwable)exception);
            }
        }));
    }

    public static void renderItem(Component type, ItemStack stack, int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        File faild = new File("hammerlib", "renderers" + File.separator + rl.m_135827_());
        File fl = new File(faild, (rl.m_135815_() + "-" + sdf.format(Date.from(Instant.now())) + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
        Stack2ImageRenderer.queueRenderer(type, stack, size, fl);
    }

    public static void renderAll(int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammerlib", "renderers" + File.separator + "all-" + sdf.format(Date.from(Instant.now())));
        ForgeRegistries.ITEMS.getValues().stream().flatMap(item -> {
            NonNullList sb = NonNullList.m_122779_();
            try {
                for (CreativeModeTab tab : item.getCreativeTabs()) {
                    item.m_6787_(tab, sb);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return sb.stream().map(stack -> new ItemWithData(stack.m_41720_(), stack.m_41783_()));
        }).distinct().forEach(s -> {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)s.item());
            File fl = new File(faild, rl.m_135827_() + File.separator + (rl.m_135815_() + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
            Stack2ImageRenderer.queueRenderer((Component)Component.m_237113_((String)"Everything"), s.stack(), size, fl);
        });
    }

    public static void renderMod(String modid, int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammerlib", "renderers" + File.separator + modid + "-" + sdf.format(Date.from(Instant.now())));
        ForgeRegistries.ITEMS.getKeys().stream().flatMap(rl -> {
            if (!rl.m_135827_().equals(modid)) {
                return Stream.empty();
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
            NonNullList sb = NonNullList.m_122779_();
            try {
                for (CreativeModeTab tab : item.getCreativeTabs()) {
                    item.m_6787_(tab, sb);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return sb.stream().map(stack -> new ItemWithData(stack.m_41720_(), stack.m_41783_()));
        }).distinct().forEach(s -> {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)s.item());
            File fl = new File(faild, (rl.m_135815_() + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
            Stack2ImageRenderer.queueRenderer((Component)Component.m_237113_((String)("Mod " + modid)), s.stack(), size, fl);
        });
    }

    public static synchronized void renderItemStack(Component type, int width, int height, ItemStack stack, Consumer<NativeImage> finishCallback) {
        QUEUE.add(new RenderQueueItem(type, width, height, stack, finishCallback));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFrameStart(TickEvent.RenderTickEvent eventThatWeDoNotCareMuchAbout) {
        if (eventThatWeDoNotCareMuchAbout.phase == TickEvent.Phase.START) {
            if (HLClientProxy.RENDER_GUI_ITEM.m_90859_()) {
                Minecraft mc = Minecraft.m_91087_();
                Cast.optionally(mc.f_91080_, AbstractContainerScreen.class).map(AbstractContainerScreen::getSlotUnderMouse).map(Slot::m_7993_).or(() -> IJeiPluginHL.get().getIngredientUnderMouseJEI(ItemStack.class)).ifPresent(stack -> {
                    int res = Mth.m_14045_((int)ConfigHL.INSTANCE.get((LogicalSide)LogicalSide.CLIENT).clientSide.guiItemRenderResolution, (int)16, (int)32768);
                    Stack2ImageRenderer.renderItem((Component)Component.m_237113_((String)"Hotkey"), stack, res);
                });
            }
            return;
        }
        if (!QUEUE.isEmpty()) {
            MainTarget renderTarget;
            block9: {
                boolean flat;
                Minecraft mc = Minecraft.m_91087_();
                ItemRenderer ir = mc.m_91291_();
                RenderQueueItem elem = QUEUE.remove(0);
                Component a = elem.work;
                renderTarget = new MainTarget(elem.width(), elem.height());
                renderTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                renderTarget.m_83954_(Minecraft.f_91002_);
                renderTarget.m_83947_(true);
                ItemStack stack2 = elem.stack();
                BakedModel model = ir.m_174264_(stack2, null, null, 0);
                mc.f_90987_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
                RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                RenderSystem.m_69478_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                PoseStack mview = RenderSystem.m_157191_();
                mview.m_85836_();
                mview.m_85841_(16.0f, 16.0f, 16.0f);
                mview.m_85837_(0.0, 0.0, 0.0);
                mview.m_85837_(13.333333333333, 7.5, 0.0);
                mview.m_85841_(1.7835498f, -1.0f, 1.0f);
                mview.m_85841_(15.0f, 15.0f, 15.0f);
                RenderSystem.m_157182_();
                PoseStack pose = new PoseStack();
                MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
                boolean bl = flat = !model.m_7547_();
                if (flat) {
                    Lighting.m_84930_();
                } else {
                    Lighting.m_84931_();
                }
                ir.m_115143_(stack2, ItemTransforms.TransformType.GUI, false, pose, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, model);
                buffers.m_109911_();
                RenderSystem.m_69482_();
                if (flat) {
                    Lighting.m_84931_();
                }
                mview.m_85849_();
                RenderSystem.m_157182_();
                try {
                    NativeImage img = new NativeImage(NativeImage.Format.RGBA, renderTarget.f_83915_, renderTarget.f_83916_, false);
                    RenderSystem.m_69396_((int)renderTarget.m_83975_());
                    img.m_85045_(0, false);
                    img.m_85122_();
                    elem.finishCallback.accept(img);
                    if (a != null) {
                        SystemToast.m_94869_((ToastComponent)mc.f_91003_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.NARRATOR_TOGGLE, (Component)a.m_6881_().m_7220_((Component)Component.m_237113_((String)": Rendered!").m_130940_(ChatFormatting.GREEN)), (Component)elem.stack.m_41611_());
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (a == null) break block9;
                    SystemToast.m_94869_((ToastComponent)mc.f_91003_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.NARRATOR_TOGGLE, (Component)a.m_6881_().m_7220_((Component)Component.m_237113_((String)": Failed!").m_130940_(ChatFormatting.RED)), (Component)elem.stack.m_41611_());
                }
            }
            renderTarget.m_83930_();
        }
    }

    private record RenderQueueItem(Component work, int width, int height, ItemStack stack, Consumer<NativeImage> finishCallback) {
    }

    private record ItemWithData(Item item, CompoundTag data) {
        public ItemStack stack() {
            ItemStack stack = new ItemStack((ItemLike)this.item);
            stack.m_41751_(this.data);
            return stack;
        }
    }
}

