/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.ModelData;
import org.zeith.hammerlib.client.render.item.Stack2ImageRenderer;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class TexturePixelGetter {
    private static final Map<ResourceLocation, int[]> colors = new HashMap<ResourceLocation, int[]>();
    private static final Map<String, int[]> cachedRenderedColorsRaw = new HashMap<String, int[]>();
    private static final Map<String, CompletableFuture<int[]>> cachedRenderedColors = new HashMap<String, CompletableFuture<int[]>>();
    private static final Map<String, Long> cachedRenderedColorsCompletionTimes = new ConcurrentHashMap<String, Long>();
    private static final ResourceLocation MISSINGNO = TexturePixelGetter.getResourceLocation(MissingTextureAtlasSprite.m_118071_());

    public static void reloadTexture(TextureStitchEvent e) {
        cachedRenderedColorsCompletionTimes.clear();
        cachedRenderedColors.clear();
        colors.clear();
    }

    private static CompletableFuture<int[]> getRenderedColors(ItemStack stack) {
        return cachedRenderedColors.computeIfAbsent(stack.toString() + "_" + stack.m_41783_(), ignore -> {
            AtomicReference colors = new AtomicReference();
            AtomicBoolean complete = new AtomicBoolean(false);
            Stack2ImageRenderer.renderItemStack(null, 64, 64, stack, image -> {
                AtomicReference atomicReference = colors;
                synchronized (atomicReference) {
                    colors.set(image);
                    complete.set(true);
                    colors.notifyAll();
                }
            });
            return CompletableFuture.supplyAsync(() -> {
                AtomicReference atomicReference = colors;
                synchronized (atomicReference) {
                    try {
                        if (!complete.get()) {
                            colors.wait(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return TexturePixelGetter.decompose((NativeImage)colors.get(), 0);
            }).thenApply(i -> {
                cachedRenderedColorsCompletionTimes.put((String)ignore, System.currentTimeMillis());
                return i;
            });
        });
    }

    public static int[] getAllColors(ItemStack stack) {
        String key = stack.toString() + "_" + stack.m_41783_();
        CompletableFuture<int[]> rendered = TexturePixelGetter.getRenderedColors(stack);
        if (rendered.isDone() && !rendered.isCompletedExceptionally()) {
            int[] colors = rendered.join();
            cachedRenderedColorsRaw.put(key, colors);
            cachedRenderedColors.remove(key);
        }
        if (cachedRenderedColorsRaw.containsKey(key)) {
            return cachedRenderedColorsRaw.get(key);
        }
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)mc.f_91073_, (LivingEntity)mc.f_91074_, 0);
        TextureAtlasSprite spr = model.getParticleIcon(ModelData.EMPTY);
        if (spr == null) {
            spr = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        return TexturePixelGetter.getAllColors(TexturePixelGetter.getResourceLocation(spr.m_118413_()));
    }

    public static int[] getAllColors(ResourceLocation texture) {
        if (colors.containsKey(texture)) {
            return colors.get(texture);
        }
        if (MISSINGNO.equals((Object)texture)) {
            colors.put(texture, new int[]{0xFF00FF, 0});
        } else {
            try {
                Resource res = Minecraft.m_91087_().m_91098_().m_213713_(texture).orElse(null);
                if (res == null) {
                    colors.put(texture, new int[]{0xFF00FF, 0});
                    return colors.get(texture);
                }
                try (InputStream in = res.m_215507_();){
                    NativeImage img = NativeImage.m_85058_((InputStream)in);
                    colors.put(texture, TexturePixelGetter.decompose(img, 0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                colors.put(texture, new int[]{0xFF00FF, 0});
            }
        }
        return colors.get(texture);
    }

    private static ResourceLocation getResourceLocation(ResourceLocation txPath) {
        return new ResourceLocation(txPath.m_135827_(), String.format(Locale.ROOT, "textures/%s%s", txPath.m_135815_(), ".png"));
    }

    public static int[] decompose(NativeImage img, int alphaThreshold) {
        if (img == null) {
            return new int[]{0xFF00FF, 0};
        }
        IntOpenHashSet ints = new IntOpenHashSet();
        for (int x = 0; x < img.m_84982_(); ++x) {
            for (int y = 0; y < img.m_85084_(); ++y) {
                int rgba = img.m_84985_(x, y);
                int a = NativeImage.m_84983_((int)rgba);
                if (a <= alphaThreshold) continue;
                int rgb = ColorHelper.packARGBi(a, NativeImage.m_85085_((int)rgba), NativeImage.m_85103_((int)rgba), NativeImage.m_85119_((int)rgba));
                ints.add(rgb);
            }
        }
        return ints.toIntArray();
    }
}

