/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.energy.IEnergyStorage;

public class TooltipUtils {
    public static final ResourceLocation ENERGY_SUB = new ResourceLocation("hammerlib", "energy");
    public static final ResourceLocation FE_DEFINITION = new ResourceLocation("hammerlib", "fe");
    private static final ThreadLocal<List<String>> TOOLTIP = ThreadLocal.withInitial(ArrayList::new);

    public static List<String> emptyTooltipList() {
        TOOLTIP.get().clear();
        return TOOLTIP.get();
    }

    public static List<String> generateEnergy(IEnergyStorage storage) {
        if (storage == null) {
            return TooltipUtils.emptyTooltipList();
        }
        return TooltipUtils.generate(ENERGY_SUB, storage.getEnergyStored(), storage.getMaxEnergyStored(), FE_DEFINITION);
    }

    public static List<String> generate(ResourceLocation sub, int val, int max, ResourceLocation definition) {
        return TooltipUtils.generateCustom("gui." + sub.m_135827_() + "." + sub.m_135815_(), val, max, definition);
    }

    public static List<String> generateCustom(String i18n, int value, int max, ResourceLocation definition) {
        Object[] objectArray;
        List<String> tip = TOOLTIP.get();
        tip.clear();
        tip.add(I18n.m_118938_((String)i18n, (Object[])new Object[0]));
        String string = ChatFormatting.GRAY + "%,d" + (max > 0 ? " / %,d" : "") + " %s";
        if (max > 0) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = value;
            objectArray2[1] = max;
            objectArray = objectArray2;
            objectArray2[2] = I18n.m_118938_((String)("definition." + definition.m_135827_() + ":" + definition.m_135815_() + "." + (Screen.m_96638_() ? "long" : "short")), (Object[])new Object[0]);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = value;
            objectArray = objectArray3;
            objectArray3[1] = I18n.m_118938_((String)("definition." + definition.m_135827_() + ":" + definition.m_135815_() + "." + (Screen.m_96638_() ? "long" : "short")), (Object[])new Object[0]);
        }
        tip.add(String.format(string, objectArray));
        return tip;
    }

    public static String intToString(long num) {
        return String.format("%,d", num);
    }
}

