/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class CreativeTabAdapter {
    private static final List<Tuple2<ItemLike, CreativeModeTab[]>> REGISTRARS = new ArrayList<Tuple2<ItemLike, CreativeModeTab[]>>();
    private static final Map<Item, Set<CreativeModeTab>> TABS = Maps.newConcurrentMap();

    public static <T extends ItemLike> T bindTab(T item, CreativeModeTab ... tabs) {
        REGISTRARS.add(Tuples.immutable(item, tabs));
        return item;
    }

    @NotNull
    public static Set<CreativeModeTab> getTabOverrides(Item item) {
        return TABS.getOrDefault(item, Collections.emptySet());
    }

    public static void deque() {
        while (!REGISTRARS.isEmpty()) {
            Tuple2<ItemLike, CreativeModeTab[]> tup = REGISTRARS.remove(0);
            TABS.computeIfAbsent(tup.a().m_5456_(), s -> Sets.newConcurrentHashSet()).addAll(Set.of(tup.b()));
        }
    }
}

