/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.RecipeShape;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class ShapedRecipeBuilder
extends RecipeBuilder<ShapedRecipeBuilder, Recipe<?>> {
    private final Map<Character, Ingredient> dictionary = new HashMap<Character, Ingredient>();
    private RecipeShape shape;

    public ShapedRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        super(event);
    }

    public ShapedRecipeBuilder shape(int width, int height, String ... shapeKeys) {
        this.shape = new RecipeShape(width, height, shapeKeys);
        return this;
    }

    public ShapedRecipeBuilder shape(String ... shapeKeys) {
        this.shape = new RecipeShape(shapeKeys);
        return this;
    }

    public ShapedRecipeBuilder map(char c, Object ingredient) {
        this.dictionary.put(Character.valueOf(c), RecipeHelper.fromComponent(ingredient));
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.shape == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined shape!");
        }
        if (this.dictionary.isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined ingredients!");
        }
    }

    @Override
    public void register() {
        this.validate();
        if (!this.event.enableRecipe(this.getIdentifier())) {
            return;
        }
        ResourceLocation id = this.getIdentifier();
        this.event.register(id, new ShapedRecipe(id, this.group, this.shape.width, this.shape.height, this.shape.createIngredientMap(this.dictionary), this.result));
    }
}

