/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class RecipeRegistrationContext {
    private final Path file;
    private final Object2BooleanMap<String> allRecipes;
    private final Set<String> usedKeys = new HashSet<String>();
    private boolean changed;

    public RecipeRegistrationContext(Path file, Object2BooleanMap<String> allRecipes) {
        this.file = file;
        this.allRecipes = allRecipes;
    }

    public boolean enableRecipe(ResourceLocation id) {
        return this.enableRecipe(id.toString());
    }

    public boolean enableRecipe(String id) {
        this.usedKeys.add(id);
        if (!this.allRecipes.containsKey((Object)id)) {
            this.allRecipes.put((Object)id, true);
            this.changed = true;
        }
        return this.allRecipes.getBoolean((Object)id);
    }

    public <RES, T extends RecipeBuilder<T, RES>> Optional<T> register(@NotNull T builder) {
        if (this.enableRecipe(builder.getIdentifier())) {
            builder.register();
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    public static RecipeRegistrationContext load(String modid) {
        Path recipes = FMLPaths.CONFIGDIR.get().resolve("hammerlib").resolve("recipes").resolve("modded").resolve(modid + ".json");
        Object2BooleanArrayMap enabledRecipes = new Object2BooleanArrayMap();
        try {
            Files.createDirectories(recipes.getParent(), new FileAttribute[0]);
            if (Files.isRegularFile(recipes, new LinkOption[0])) {
                new JSONTokener(Files.readString(recipes)).nextValueOBJ().ifPresent(arg_0 -> RecipeRegistrationContext.lambda$load$0((Object2BooleanMap)enabledRecipes, arg_0));
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
        return new RecipeRegistrationContext(recipes, (Object2BooleanMap<String>)enabledRecipes);
    }

    public void save() {
        if (this.changed) {
            JSONObject active = new JSONObject();
            JSONObject disabled = new JSONObject();
            for (Object2BooleanMap.Entry entry : this.allRecipes.object2BooleanEntrySet()) {
                (this.usedKeys.contains(entry.getKey()) ? active : disabled).put((String)entry.getKey(), entry.getBooleanValue());
            }
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                Files.writeString(this.file, (CharSequence)new JSONObject().put("active", active).put("unregistered", disabled).toString(4), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static /* synthetic */ void lambda$load$0(Object2BooleanMap enabledRecipes, JSONObject obj) {
        JSONObject $ = obj.getJSONObject("active");
        for (String key : $.keySet()) {
            enabledRecipes.put((Object)key, $.optBoolean(key, true));
        }
        $ = obj.getJSONObject("unregistered");
        for (String key : $.keySet()) {
            enabledRecipes.put((Object)key, $.optBoolean(key, true));
        }
    }
}

