/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.physics;

import org.zeith.hammerlib.api.io.IAutoNBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializable;

public class FrictionRotator
implements IAutoNBTSerializable {
    @NBTSerializable(value="current_speed")
    public float currentSpeed;
    @NBTSerializable
    public float rotation;
    @NBTSerializable
    public float speed;
    @NBTSerializable
    public float friction = 1.0f;
    public float prevRotation;

    public void speedupTo(float dstSpeed, float maxStep) {
        this.speedup(Math.min(maxStep, dstSpeed - this.speed));
    }

    public void speedup(float speed) {
        this.speed += speed;
    }

    public float getActualRotation(float partialTime) {
        return (this.prevRotation + (this.rotation - this.prevRotation) * partialTime) % 360.0f;
    }

    public float getActualRotationRaw(float partialTime) {
        return this.prevRotation + (this.rotation - this.prevRotation) * partialTime;
    }

    public void update() {
        if (Float.isNaN(this.speed)) {
            this.speed = 0.0f;
        }
        if (Float.isNaN(this.currentSpeed)) {
            this.currentSpeed = 0.0f;
        }
        if (this.currentSpeed > this.speed) {
            this.currentSpeed = (float)((double)this.currentSpeed - Math.sqrt(this.currentSpeed - this.speed));
        } else if (this.speed > this.currentSpeed) {
            this.currentSpeed = (float)((double)this.currentSpeed + Math.sqrt(this.speed - this.currentSpeed));
        }
        if (Math.abs(this.currentSpeed) - this.friction <= 4.0E-4f) {
            this.currentSpeed = 0.0f;
        }
        this.prevRotation = this.rotation;
        this.rotation += this.currentSpeed;
        float frictionBoost = (float)Math.sqrt(Math.sqrt(Math.abs(this.speed)));
        if (this.speed > 0.0f) {
            this.speed = Math.max(0.0f, this.speed - this.friction * frictionBoost);
        } else if (this.speed < 0.0f) {
            this.speed = Math.min(0.0f, this.speed + this.friction * frictionBoost);
        }
    }
}

