/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.items;

import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.items.APItem;
import de.srendi.advancedperipherals.common.setup.Items;
import de.srendi.advancedperipherals.common.util.EnumColor;
import de.srendi.advancedperipherals.lib.metaphysics.IFeedableAutomataCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakAutomataCore
extends APItem
implements IFeedableAutomataCore {
    private static final String CONSUMED_ENTITY_COUNT = "consumed_entity_count";
    private static final String CONSUMED_ENTITY_NAME = "consumed_entity_name";
    private static final String CONSUMER_ENTITY_COMPOUND = "consumed_entity_compound";
    private static final Map<String, WeakAutomataCoreRecord> AUTOMATA_CORE_REGISTRY = new HashMap<String, WeakAutomataCoreRecord>();

    public WeakAutomataCore(Item.Properties properties, @Nullable ResourceLocation turtleID, @Nullable ResourceLocation pocketID) {
        super(properties, turtleID, pocketID, (Supplier<Boolean>)APConfig.METAPHYSICS_CONFIG.enableWeakAutomataCore);
    }

    public WeakAutomataCore(@Nullable ResourceLocation turtleID, @Nullable ResourceLocation pocketID) {
        super(turtleID, pocketID, (Supplier<Boolean>)APConfig.METAPHYSICS_CONFIG.enableWeakAutomataCore);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41784_();
        CompoundTag consumedData = tag.m_128469_(CONSUMER_ENTITY_COMPOUND);
        consumedData.m_128431_().forEach(key -> {
            WeakAutomataCoreRecord record = AUTOMATA_CORE_REGISTRY.get(key);
            CompoundTag recordData = consumedData.m_128469_(key);
            tooltip.add(EnumColor.buildTextComponent((Component)Component.m_237113_((String)String.format("Consumed: %d/%d %s", recordData.m_128451_(CONSUMED_ENTITY_COUNT), record.getRequiredCount((String)key), recordData.m_128461_(CONSUMED_ENTITY_NAME)))));
        });
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (!(player instanceof FakePlayer)) {
            player.m_5661_((Component)Component.m_237115_((String)"text.advancedperipherals.automata_core_feed_by_player"), true);
            return InteractionResult.FAIL;
        }
        String entityType = EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
        if (AUTOMATA_CORE_REGISTRY.containsKey(entityType)) {
            WeakAutomataCoreRecord record;
            CompoundTag tag = stack.m_41784_();
            CompoundTag consumedData = tag.m_128469_(CONSUMER_ENTITY_COMPOUND);
            if (consumedData.m_128456_()) {
                record = AUTOMATA_CORE_REGISTRY.get(entityType);
            } else {
                Optional anyKey = consumedData.m_128431_().stream().findAny();
                if (!anyKey.isPresent()) {
                    return InteractionResult.PASS;
                }
                record = AUTOMATA_CORE_REGISTRY.get(anyKey.get());
            }
            if (!record.isSuitable(entityType, consumedData)) {
                return InteractionResult.PASS;
            }
            entity.m_142687_(Entity.RemovalReason.KILLED);
            CompoundTag entityCompound = consumedData.m_128469_(entityType);
            entityCompound.m_128405_(CONSUMED_ENTITY_COUNT, entityCompound.m_128451_(CONSUMED_ENTITY_COUNT) + 1);
            entityCompound.m_128359_(CONSUMED_ENTITY_NAME, entity.m_7755_().getString());
            consumedData.m_128365_(entityType, (Tag)entityCompound);
            if (record.isFinished(consumedData)) {
                player.m_21008_(hand, new ItemStack((ItemLike)record.resultSoul));
            }
            tag.m_128365_(CONSUMER_ENTITY_COMPOUND, (Tag)consumedData);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        HashMap<String, Integer> endSouls = new HashMap<String, Integer>();
        endSouls.put(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20566_).toString(), 10);
        WeakAutomataCoreRecord endSoulRecord = new WeakAutomataCoreRecord(endSouls, (Item)Items.END_AUTOMATA_CORE.get());
        HashMap<String, Integer> husbandrySouls = new HashMap<String, Integer>();
        husbandrySouls.put(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20557_).toString(), 3);
        husbandrySouls.put(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20520_).toString(), 3);
        husbandrySouls.put(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20555_).toString(), 3);
        WeakAutomataCoreRecord husbandrySoulRecord = new WeakAutomataCoreRecord(husbandrySouls, (Item)Items.HUSBANDRY_AUTOMATA_CORE.get());
        endSoulRecord.ingredients.keySet().forEach(entityType -> AUTOMATA_CORE_REGISTRY.put((String)entityType, endSoulRecord));
        husbandrySoulRecord.ingredients.keySet().forEach(entityType -> AUTOMATA_CORE_REGISTRY.put((String)entityType, husbandrySoulRecord));
    }

    public record WeakAutomataCoreRecord(Map<String, Integer> ingredients, Item resultSoul) {
        public int getRequiredCount(String entityType) {
            return this.ingredients.getOrDefault(entityType, 0);
        }

        public boolean isSuitable(String entityType, CompoundTag consumedData) {
            if (!this.ingredients.containsKey(entityType)) {
                return false;
            }
            int requiredCount = this.ingredients.get(entityType);
            int currentCount = consumedData.m_128469_(entityType).m_128451_(WeakAutomataCore.CONSUMED_ENTITY_COUNT);
            return currentCount < requiredCount;
        }

        public boolean isFinished(CompoundTag consumedData) {
            return this.ingredients.entrySet().stream().map(entry -> ((Integer)entry.getValue()).intValue() == consumedData.m_128469_((String)entry.getKey()).m_128451_(WeakAutomataCore.CONSUMED_ENTITY_COUNT)).reduce((a, b) -> a != false && b != false).orElse(true);
        }
    }
}

