/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block.table.table;

import earth.terrarium.handcrafted.common.block.ItemHoldingBlockEntity;
import earth.terrarium.handcrafted.common.block.property.SheetState;
import earth.terrarium.handcrafted.common.block.property.TableState;
import earth.terrarium.handcrafted.common.block.table.table.TableBlockEntity;
import earth.terrarium.handcrafted.common.registry.ModTags;
import java.util.stream.Stream;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class TableBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<TableState> TABLE_BLOCK_SHAPE = EnumProperty.m_61587_((String)"table_shape", TableState.class);
    public static final EnumProperty<SheetState> TABLE_SHEET_SHAPE = EnumProperty.m_61587_((String)"sheet_shape", SheetState.class);
    public static final VoxelShape SINGLE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_EAST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0));
    public static final VoxelShape NORTH_WEST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0));
    public static final VoxelShape SOUTH_EAST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0));
    public static final VoxelShape SOUTH_WEST_CORNER_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0));
    public static final VoxelShape NORTH_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape EAST_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape SOUTH_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape WEST_SIDE_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)).reduce(Shapes::m_83110_).get();

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TABLE_BLOCK_SHAPE, (Comparable)((Object)TableState.SINGLE))).m_61124_(TABLE_SHEET_SHAPE, (Comparable)((Object)SheetState.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TableBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((TableState)((Object)state.m_61143_(TABLE_BLOCK_SHAPE))) {
            default -> throw new IncompatibleClassChangeError();
            case TableState.SINGLE -> SINGLE_SHAPE;
            case TableState.CENTER -> CENTER_SHAPE;
            case TableState.NORTH_EAST_CORNER -> NORTH_EAST_CORNER_SHAPE;
            case TableState.NORTH_WEST_CORNER -> NORTH_WEST_CORNER_SHAPE;
            case TableState.SOUTH_EAST_CORNER -> SOUTH_EAST_CORNER_SHAPE;
            case TableState.SOUTH_WEST_CORNER -> SOUTH_WEST_CORNER_SHAPE;
            case TableState.NORTH_SIDE -> NORTH_SIDE_SHAPE;
            case TableState.EAST_SIDE -> EAST_SIDE_SHAPE;
            case TableState.SOUTH_SIDE -> SOUTH_SIDE_SHAPE;
            case TableState.WEST_SIDE -> WEST_SIDE_SHAPE;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TABLE_BLOCK_SHAPE, TABLE_SHEET_SHAPE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)((BlockState)state.m_61124_(TABLE_BLOCK_SHAPE, (Comparable)((Object)this.getShape((BlockGetter)level, currentPos)))).m_61124_(TABLE_SHEET_SHAPE, (Comparable)((Object)this.getSheetShape((BlockGetter)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)((BlockState)blockState.m_61124_(TABLE_BLOCK_SHAPE, (Comparable)((Object)this.getShape((BlockGetter)context.m_43725_(), blockPos)))).m_61124_(TABLE_SHEET_SHAPE, (Comparable)((Object)this.getSheetShape((BlockGetter)context.m_43725_(), blockPos)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return ItemHoldingBlockEntity.placeItem(level, pos, player, ItemStack.f_41583_, f -> f.m_204117_(ModTags.SHEETS), SoundEvents.f_12642_);
    }

    public TableState getShape(BlockGetter level, BlockPos pos) {
        boolean northPresent = level.m_8055_(pos.m_121945_(Direction.NORTH)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        boolean eastPresent = level.m_8055_(pos.m_121945_(Direction.EAST)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        boolean southPresent = level.m_8055_(pos.m_121945_(Direction.SOUTH)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        boolean westPresent = level.m_8055_(pos.m_121945_(Direction.WEST)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        if (northPresent && eastPresent && southPresent && westPresent) {
            return TableState.CENTER;
        }
        if (northPresent && southPresent) {
            return TableState.CENTER;
        }
        if (eastPresent && westPresent) {
            return TableState.CENTER;
        }
        if (northPresent && eastPresent) {
            return TableState.SOUTH_WEST_CORNER;
        }
        if (eastPresent && southPresent) {
            return TableState.NORTH_WEST_CORNER;
        }
        if (southPresent && westPresent) {
            return TableState.NORTH_EAST_CORNER;
        }
        if (westPresent && northPresent) {
            return TableState.SOUTH_EAST_CORNER;
        }
        if (northPresent) {
            return TableState.SOUTH_SIDE;
        }
        if (eastPresent) {
            return TableState.WEST_SIDE;
        }
        if (southPresent) {
            return TableState.NORTH_SIDE;
        }
        if (westPresent) {
            return TableState.EAST_SIDE;
        }
        return TableState.SINGLE;
    }

    public SheetState getSheetShape(BlockGetter level, BlockPos pos) {
        boolean northPresent = level.m_8055_(pos.m_121945_(Direction.NORTH)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        boolean eastPresent = level.m_8055_(pos.m_121945_(Direction.EAST)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        boolean southPresent = level.m_8055_(pos.m_121945_(Direction.SOUTH)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        boolean westPresent = level.m_8055_(pos.m_121945_(Direction.WEST)).m_204336_(ModTags.TABLE_ATTACHMENTS);
        if (northPresent && eastPresent && southPresent && westPresent) {
            return SheetState.CENTER;
        }
        if (northPresent && eastPresent && southPresent) {
            return SheetState.WEST_SIDE;
        }
        if (northPresent && eastPresent && westPresent) {
            return SheetState.SOUTH_SIDE;
        }
        if (northPresent && southPresent && westPresent) {
            return SheetState.EAST_SIDE;
        }
        if (eastPresent && southPresent && westPresent) {
            return SheetState.NORTH_SIDE;
        }
        if (northPresent && eastPresent) {
            return SheetState.SOUTH_WEST_CORNER;
        }
        if (eastPresent && southPresent) {
            return SheetState.NORTH_WEST_CORNER;
        }
        if (southPresent && westPresent) {
            return SheetState.NORTH_EAST_CORNER;
        }
        if (westPresent && northPresent) {
            return SheetState.SOUTH_EAST_CORNER;
        }
        if (northPresent) {
            return SheetState.SOUTH_COVER;
        }
        if (eastPresent) {
            return SheetState.WEST_COVER;
        }
        if (southPresent) {
            return SheetState.NORTH_COVER;
        }
        if (westPresent) {
            return SheetState.EAST_COVER;
        }
        return SheetState.SINGLE;
    }
}

