/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.entity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import earth.terrarium.handcrafted.common.block.SittableBlock;
import earth.terrarium.handcrafted.common.registry.ModEntityTypes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public class SittingEntity
extends Entity {
    public static final Multimap<ResourceKey<Level>, BlockPos> SITTING_POSITIONS = ArrayListMultimap.create();
    private AABB shape;
    private boolean remove;
    private boolean canRotate;

    public SittingEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.m_141960_(EntityInLevelCallback.f_156799_);
    }

    public SittingEntity(Level level, AABB shape) {
        super((EntityType)ModEntityTypes.SEAT.get(), level);
        this.shape = SittingEntity.copyAABB(shape);
    }

    public static SittingEntity of(Level level, BlockPos pos, Direction dir) {
        BlockState state = level.m_8055_(pos);
        AABB shape = new AABB(pos);
        Block block = state.m_60734_();
        if (block instanceof SittableBlock) {
            SittableBlock seat = (SittableBlock)block;
            shape = seat.getSeatSize(state);
        }
        SittingEntity entity = new SittingEntity(level, shape);
        if (dir != null) {
            entity.m_146922_(dir.m_122435_());
        } else {
            entity.canRotate = true;
        }
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        return entity;
    }

    private static AABB copyAABB(AABB aabb) {
        return new AABB(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.canRotate ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.canRotate = packet.m_131509_() == 1;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_20160_() {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return false;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        return RespawnAnchorBlock.m_55839_((EntityType)passenger.m_6095_(), (CollisionGetter)this.f_19853_, (BlockPos)this.m_20183_()).orElse(super.m_7688_(passenger));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.f_19853_.m_5776_() || this.f_19853_.m_8055_(this.m_20183_()).m_60734_() instanceof SittableBlock && !this.remove)) {
            this.removeSeat();
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.f_19853_.m_5776_() && this.m_20197_().isEmpty()) {
            this.remove = true;
        }
    }

    public void removeSeat() {
        SITTING_POSITIONS.get((Object)this.f_19853_.m_46472_()).remove(this.m_20183_());
        this.m_146870_();
    }

    protected AABB m_142242_() {
        if (this.shape == null) {
            return super.m_142242_();
        }
        return this.shape.m_82338_(this.m_20183_());
    }

    public double m_6048_() {
        if (this.shape == null) {
            return super.m_6048_();
        }
        return this.shape.m_82376_() * 0.75;
    }

    protected void clampRotation(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += g - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + g - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    public void m_7340_(Entity entityToUpdate) {
        if (!this.canRotate) {
            this.clampRotation(entityToUpdate);
        }
    }

    public void m_141960_(EntityInLevelCallback levelCallback) {
        super.m_141960_((EntityInLevelCallback)new WrapedLevelCallBack(levelCallback));
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    private class WrapedLevelCallBack
    implements EntityInLevelCallback {
        private final EntityInLevelCallback callback;

        public WrapedLevelCallBack(EntityInLevelCallback callback) {
            this.callback = callback;
        }

        public void m_142044_() {
            if (this.callback != null) {
                this.callback.m_142044_();
                Block block = SittingEntity.this.f_19853_.m_8055_(SittingEntity.this.m_20183_()).m_60734_();
                if (block instanceof SittableBlock) {
                    SittableBlock seat = (SittableBlock)block;
                    SittingEntity.this.shape = seat.getSeatSize(SittingEntity.this.f_19853_.m_8055_(SittingEntity.this.m_20183_()));
                }
            } else {
                SittingEntity.this.shape = null;
            }
        }

        public void m_142472_(Entity.RemovalReason reason) {
            if (this.callback != null) {
                this.callback.m_142472_(reason);
            }
        }
    }
}

