/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TransporterTESR
implements BlockEntityRenderer<TransporterTile> {
    public static ResourceLocation TEXTURE = new ResourceLocation("industrialforegoing", "textures/blocks/transporters/particle.png");
    public static RenderType TYPE = TransporterTESR.createRenderType();

    public TransporterTESR(BlockEntityRendererProvider.Context context) {
    }

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TEXTURE, false, false)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        })).m_110691_(true);
        return RenderType.m_173215_((String)"transporter_render", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static Vector3f getPath(Direction from, Direction to, double step, float partialTicks) {
        float totalSteps = 5.0f;
        if (from.m_122424_() == to) {
            totalSteps = 7.0f;
            Vec3 vector3d = new Vec3((double)(to.m_122432_().m_122239_() / totalSteps) * step, (double)(to.m_122432_().m_122260_() / totalSteps) * step, (double)(to.m_122432_().m_122269_() / totalSteps) * step);
            if (from.m_122434_() == Direction.Axis.X) {
                vector3d = vector3d.m_82520_(0.0, 0.5, 0.5);
                if (from.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.m_82520_(1.0, 0.0, 0.0);
                }
            }
            if (from.m_122434_() == Direction.Axis.Z) {
                vector3d = vector3d.m_82520_(0.5, 0.5, 0.0);
                if (from.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.m_82520_(0.0, 0.0, 1.0);
                }
            }
            if (from.m_122434_() == Direction.Axis.Y) {
                vector3d = vector3d.m_82520_(0.5, 0.0, 0.5);
                if (from.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.m_82520_(0.0, 1.0, 0.0);
                }
            }
            float divideSecond = -0.22f;
            vector3d = vector3d.m_82520_((double)(from.m_122432_().m_122239_() * divideSecond), (double)(from.m_122432_().m_122260_() * divideSecond), (double)(from.m_122432_().m_122269_() * divideSecond));
            return new Vector3f(vector3d);
        }
        Vector3f vsrc = from.m_122432_();
        Vector3f vdst = to.m_122432_();
        Vector3f a = vsrc.m_122281_();
        a.m_122261_(0.3125f);
        Vector3f b = vdst.m_122281_();
        b.m_122261_(0.375f);
        Vector3f c = vsrc.m_122281_();
        c.m_122261_(0.1875f);
        float sind = -Mth.m_14031_((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        float cosd = -Mth.m_14089_((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        a.m_122261_(sind);
        b.m_122261_(cosd);
        a.m_122253_(b);
        a.m_122253_(c);
        float divide = 2.5f;
        a.m_122272_(vdst.m_122239_() / divide, vdst.m_122260_() / divide, vdst.m_122269_() / divide);
        a.m_122272_(0.5f, 0.5f, 0.5f);
        float divideSecond = 0.15f;
        a.m_122272_(vsrc.m_122239_() * divideSecond, vsrc.m_122260_() * divideSecond, vsrc.m_122269_() * divideSecond);
        return a;
    }

    public void render(TransporterTile tile, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Map<Direction, TransporterType> transporters = tile.getTransporterTypeMap();
        for (Direction direction : transporters.keySet()) {
            if (transporters.get(direction).getAction() != TransporterTypeFactory.TransporterAction.EXTRACT) continue;
            for (Direction other : transporters.keySet()) {
                if (direction == other || !transporters.get(direction).getFactory().getName().equals(transporters.get(other).getFactory().getName()) || transporters.get(other).getAction() == TransporterTypeFactory.TransporterAction.EXTRACT) continue;
                for (int i = -1; i < 6; ++i) {
                    stack.m_85836_();
                    Vector3f pos = TransporterTESR.getPath(direction, other, (float)i + partialTicks, partialTicks);
                    stack.m_85837_((double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_());
                    transporters.get(other).renderTransfer(pos, direction, i + 1, stack, combinedOverlayIn, buffer, partialTicks);
                    stack.m_85849_();
                }
            }
        }
    }
}

