/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Collections;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.buffer.ShaderStorageBuffer;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.sampler.SamplerLimits;

public class ShaderStorageBufferHolder {
    private int cachedWidth;
    private int cachedHeight;
    private ShaderStorageBuffer[] buffers;
    private boolean destroyed = false;

    public ShaderStorageBufferHolder(Int2ObjectArrayMap<ShaderStorageInfo> overrides, int width, int height) {
        this.cachedWidth = width;
        this.cachedHeight = height;
        this.buffers = new ShaderStorageBuffer[(Integer)Collections.max(overrides.keySet()) + 1];
        overrides.forEach((index, bufferInfo) -> {
            if ((long)bufferInfo.size() > IrisRenderSystem.getVRAM()) {
                throw new OutOfVideoMemoryError("We only have " + ShaderStorageBufferHolder.toMib(IrisRenderSystem.getVRAM()) + "MiB of RAM to work with, but the pack is requesting " + bufferInfo.size() + "! Can't continue.");
            }
            if (index > SamplerLimits.get().getMaxShaderStorageUnits()) {
                throw new IllegalStateException("We don't have enough SSBO units??? (index: " + index + ", max: " + SamplerLimits.get().getMaxShaderStorageUnits());
            }
            this.buffers[index.intValue()] = new ShaderStorageBuffer((int)index, (ShaderStorageInfo)bufferInfo);
            int buffer = this.buffers[index].getId();
            if (bufferInfo.relative()) {
                this.buffers[index].resizeIfRelative(width, height);
            } else {
                GlStateManager.m_84480_((int)37074, (int)buffer);
                IrisRenderSystem.bufferStorage(37074, bufferInfo.size(), 0);
                IrisRenderSystem.clearBufferSubData(37074, 33321, 0L, bufferInfo.size(), 6403, 5120, new int[]{0});
                IrisRenderSystem.bindBufferBase(37074, index, buffer);
            }
        });
        GlStateManager.m_84480_((int)37074, (int)0);
    }

    public void hasResizedScreen(int width, int height) {
        if (width != this.cachedWidth || height != this.cachedHeight) {
            this.cachedWidth = width;
            this.cachedHeight = height;
            for (ShaderStorageBuffer buffer : this.buffers) {
                buffer.resizeIfRelative(width, height);
            }
        }
    }

    private static long toMib(long x) {
        return x / 1024L / 1024L;
    }

    public void setupBuffers() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed buffer objects");
        }
        for (ShaderStorageBuffer buffer : this.buffers) {
            buffer.bind();
        }
    }

    public void destroyBuffers() {
        for (ShaderStorageBuffer buffer : this.buffers) {
            buffer.destroy();
        }
        this.buffers = null;
        this.destroyed = true;
    }

    private static class OutOfVideoMemoryError
    extends RuntimeException {
        public OutOfVideoMemoryError(String s) {
            super(s);
        }
    }
}

