/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.util.TextUtils;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ClientQuestFile
extends QuestFile {
    private static final List<String> MISSING_DATA_ERR = List.of("Unable to open Quest GUI: no quest book data received from server!", "- Check that FTB Quests and FTB Teams are installed on the server", "  and that no server-side errors were logged when you connected.");
    public static ClientQuestFile INSTANCE;
    public TeamData self;
    public QuestScreen questScreen;
    private QuestScreen.PersistedData persistedData;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load() {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = new TeamData(Util.f_137441_);
        this.self.file = this;
        this.self.name = "Loading...";
        this.self.setLocked(true);
        INSTANCE = this;
        this.refreshGui();
        FTBQuests.getRecipeModHelper().refreshRecipes(this);
    }

    @Override
    public boolean canEdit() {
        return Minecraft.m_91087_().f_91074_ != null && this.self.getCanEdit((Player)Minecraft.m_91087_().f_91074_);
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        if (this.questScreen != null) {
            this.persistedData = this.questScreen.getPersistedScreenData();
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                Minecraft.m_91087_().m_91152_(null);
                this.questScreen = new QuestScreen(this, this.persistedData);
                this.questScreen.openGui();
            }
        }
    }

    public static QuestScreen openGui() {
        if (INSTANCE != null) {
            return INSTANCE.openQuestGui();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            MISSING_DATA_ERR.forEach(arg_0 -> ClientQuestFile.lambda$openGui$0((Player)player, arg_0));
        }
        return null;
    }

    public static QuestScreen openGui(Quest quest, boolean focused) {
        QuestScreen screen = ClientQuestFile.openGui();
        if (screen != null) {
            screen.open(quest, focused);
        }
        return screen;
    }

    private QuestScreen openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.disableGui && !this.canEdit()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)Component.m_237115_((String)"item.ftbquests.book.disabled"), Icons.BARRIER, (Component)Component.m_237119_()));
            } else if (this.self.isLocked()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new CustomToast((Component)(this.lockMessage.isEmpty() ? Component.m_237113_((String)"Quests locked!") : TextUtils.parseRawText(this.lockMessage)), Icons.BARRIER, (Component)Component.m_237119_()));
            } else {
                if (this.canEdit()) {
                    StructureTask.maybeRequestStructureSync();
                }
                this.questScreen = new QuestScreen(this, this.persistedData);
                this.questScreen.openGui();
                this.questScreen.refreshWidgets();
                return this.questScreen;
            }
        }
        return null;
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getData(Entity player) {
        return player == Minecraft.m_91087_().f_91074_ ? this.self : this.getData(Objects.requireNonNull(ClientTeamManager.INSTANCE.getKnownPlayer((UUID)player.m_20148_()), (String)"Non-null team required!").teamId);
    }

    public void setPersistedScreenInfo(QuestScreen.PersistedData persistedData) {
        this.persistedData = persistedData;
    }

    public static boolean canClientPlayerEdit() {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.self.getCanEdit(FTBQuests.PROXY.getClientPlayer());
    }

    public static boolean isQuestPinned(long id) {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.self.isQuestPinned(FTBQuests.PROXY.getClientPlayer(), id);
    }

    @Override
    public boolean isPlayerOnTeam(Player player, TeamData teamData) {
        KnownClientPlayer knownPlayer = ClientTeamManager.INSTANCE.getKnownPlayer(player.m_20148_());
        return knownPlayer != null && knownPlayer.teamId.equals(teamData.uuid);
    }

    public static void openBookToQuestObject(long id) {
        if (ClientQuestFile.exists()) {
            ClientQuestFile file = INSTANCE;
            if (file.questScreen == null) {
                INSTANCE.openQuestGui();
            }
            if (file.questScreen != null) {
                if (id != 0L) {
                    QuestObject qo = file.get(id);
                    if (qo != null) {
                        file.questScreen.open(qo, true);
                    }
                } else {
                    file.questScreen.openGui();
                }
            }
        }
    }

    private static /* synthetic */ void lambda$openGui$0(Player player, String s) {
        player.m_5661_((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.RED), false);
    }
}

