/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.utils;

import com.cyanogen.experienceobelisk.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RecipeUtils {
    public static List<Item> getValidDyes() {
        ArrayList<Item> validDyes = new ArrayList<Item>();
        validDyes.add(Items.f_42535_);
        validDyes.add(Items.f_42536_);
        validDyes.add(Items.f_42537_);
        validDyes.add(Items.f_42538_);
        validDyes.add(Items.f_42539_);
        validDyes.add(Items.f_42540_);
        validDyes.add(Items.f_42489_);
        validDyes.add(Items.f_42490_);
        validDyes.add(Items.f_42491_);
        validDyes.add(Items.f_42492_);
        validDyes.add(Items.f_42493_);
        validDyes.add(Items.f_42494_);
        validDyes.add(Items.f_42495_);
        validDyes.add(Items.f_42496_);
        validDyes.add(Items.f_42497_);
        validDyes.add(Items.f_42498_);
        return validDyes;
    }

    public static int dyeColorToTextColor(int dyeColor) {
        return switch (dyeColor) {
            case 0 -> 15;
            case 1 -> 6;
            case 2 -> 5;
            case 3 -> 11;
            case 4 -> 14;
            case 5 -> 10;
            case 6 -> 12;
            case 7 -> 7;
            case 8 -> 9;
            case 9 -> 3;
            case 10 -> 13;
            case 11 -> 1;
            case 12 -> 8;
            case 13 -> 2;
            case 14 -> 4;
            case 15 -> 0;
            default -> 15;
        };
    }

    public static List<Item> getValidFormattingItems() {
        ArrayList<Item> validFormattingItems = new ArrayList<Item>();
        validFormattingItems.add(Items.f_42729_);
        validFormattingItems.add(Items.f_220224_);
        validFormattingItems.add(Items.f_42713_);
        validFormattingItems.add(Items.f_42686_);
        validFormattingItems.add(Items.f_41996_);
        return validFormattingItems;
    }

    public static char itemToFormat(int index) {
        return switch (index) {
            case 0 -> 'k';
            case 1 -> 'l';
            case 2 -> 'm';
            case 3 -> 'n';
            case 4 -> 'r';
            default -> 'f';
        };
    }

    public static List<MolecularMetamorpherRecipe> getNameFormattingRecipesForJEI() {
        ItemStack outputItem;
        ChatFormatting format;
        HashMap<Ingredient, Tuple> ingredientMap2;
        ArrayList<MolecularMetamorpherRecipe> recipes = new ArrayList<MolecularMetamorpherRecipe>();
        ItemStack exampleItem = new ItemStack((ItemLike)RegisterItems.DUMMY_SWORD.get(), 1);
        ItemStack inputItem = exampleItem.m_41777_().m_41714_((Component)Component.m_237115_((String)"jei.experienceobelisk.name.any_item"));
        int cost = 315;
        int processTime = 60;
        ResourceLocation id = new ResourceLocation("experienceobelisk", "item_name_formatting");
        HashMap<Ingredient, Tuple> ingredientMap = new HashMap<Ingredient, Tuple>();
        ingredientMap.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputItem}), new Tuple((Object)1, (Object)1));
        ingredientMap.put(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42656_}), new Tuple((Object)2, (Object)1));
        for (Item dye : RecipeUtils.getValidDyes()) {
            ingredientMap2 = new HashMap<Ingredient, Tuple>(Map.copyOf(ingredientMap));
            ingredientMap2.put(Ingredient.m_43929_((ItemLike[])new ItemLike[]{dye}), new Tuple((Object)3, (Object)1));
            if (!(dye instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)dye;
            int dyeColor = dyeItem.m_41089_().m_41060_();
            format = ChatFormatting.m_126647_((int)RecipeUtils.dyeColorToTextColor(dyeColor));
            assert (format != null);
            outputItem = exampleItem.m_41777_().m_41714_((Component)Component.m_237115_((String)"jei.experienceobelisk.name.any_item").m_130940_(format));
            recipes.add(new MolecularMetamorpherRecipe((ImmutableMap<Ingredient, Tuple<Integer, Integer>>)ImmutableMap.copyOf(ingredientMap2), outputItem, cost, processTime, id));
        }
        for (Item item : RecipeUtils.getValidFormattingItems()) {
            ingredientMap2 = new HashMap(Map.copyOf(ingredientMap));
            ingredientMap2.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item.m_7968_()}), new Tuple((Object)3, (Object)1));
            int index = RecipeUtils.getValidFormattingItems().indexOf(item);
            char code = RecipeUtils.itemToFormat(index);
            format = ChatFormatting.m_126645_((char)code);
            assert (format != null);
            outputItem = exampleItem.m_41777_().m_41714_((Component)Component.m_237115_((String)"jei.experienceobelisk.name.any_item").m_130940_(format));
            recipes.add(new MolecularMetamorpherRecipe((ImmutableMap<Ingredient, Tuple<Integer, Integer>>)ImmutableMap.copyOf(ingredientMap2), outputItem, cost, processTime, id));
        }
        return recipes;
    }

    public static List<ItemStack> getItemListWithCounts(Ingredient ingredient, int count) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredient.m_43908_()) {
            ItemStack stack2 = stack.m_41777_();
            stack2.m_41764_(count);
            list.add(stack2);
        }
        return list;
    }
}

